/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.animation;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import org.assertj.android.api.animation.AbstractAnimatorAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=11)
public abstract class AbstractValueAnimatorAssert<S extends AbstractValueAnimatorAssert<S, A>, A extends ValueAnimator>
extends AbstractAnimatorAssert<S, A> {
    protected AbstractValueAnimatorAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    @TargetApi(value=12)
    public S hasAnimatedFraction(float fraction) {
        this.isNotNull();
        float actualFraction = ((ValueAnimator)this.actual).getAnimatedFraction();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualFraction).overridingErrorMessage("Expected animated fraction <%s> but was <%s>.", new Object[]{Float.valueOf(fraction), Float.valueOf(actualFraction)})).isEqualTo(fraction);
        return (S)((Object)((AbstractValueAnimatorAssert)this.myself));
    }

    public S hasAnimatedValue(Object value) {
        this.isNotNull();
        Object actualValue = ((ValueAnimator)this.actual).getAnimatedValue();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualValue).overridingErrorMessage("Expected animated value <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo(value);
        return (S)((Object)((AbstractValueAnimatorAssert)this.myself));
    }

    public S hasCurrentPlayTime(long time) {
        this.isNotNull();
        long actualTime = ((ValueAnimator)this.actual).getCurrentPlayTime();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTime).overridingErrorMessage("Expected current play time <%s> but was <%s>.", new Object[]{time, actualTime})).isEqualTo(time);
        return (S)((Object)((AbstractValueAnimatorAssert)this.myself));
    }

    public S hasRepeatCount(int count) {
        this.isNotNull();
        int actualCount = ((ValueAnimator)this.actual).getRepeatCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected repeat count <%s> but was <%s>.", new Object[]{AbstractValueAnimatorAssert.repeatCountToString(count), AbstractValueAnimatorAssert.repeatCountToString(actualCount)})).isEqualTo(count);
        return (S)((Object)((AbstractValueAnimatorAssert)this.myself));
    }

    public S hasRepeatMode(int mode) {
        this.isNotNull();
        int actualMode = ((ValueAnimator)this.actual).getRepeatMode();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected repeat mode <%s> but was <%s>.", new Object[]{AbstractValueAnimatorAssert.repeatModeToString(mode), AbstractValueAnimatorAssert.repeatModeToString(actualMode)})).isEqualTo(mode);
        return (S)((Object)((AbstractValueAnimatorAssert)this.myself));
    }

    public static String repeatCountToString(int count) {
        return IntegerUtils.buildNamedValueString(count).value(-1, "infinite").getOrValue();
    }

    public static String repeatModeToString(int mode) {
        return IntegerUtils.buildNamedValueString(mode).value(1, "restart").value(2, "reverse").get();
    }
}

