/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler.internal.reference;

import com.squareup.anvil.annotations.ExperimentalAnvilApi;
import com.squareup.anvil.compiler.internal.reference.AnnotatedReference;
import com.squareup.anvil.compiler.internal.reference.AnnotationReference;
import com.squareup.anvil.compiler.internal.reference.AnnotationReferenceKt;
import com.squareup.anvil.compiler.internal.reference.AnvilModuleDescriptor;
import com.squareup.anvil.compiler.internal.reference.ClassReference;
import com.squareup.anvil.compiler.internal.reference.FunctionReference;
import com.squareup.anvil.compiler.internal.reference.MemberFunctionReference;
import com.squareup.anvil.compiler.internal.reference.ParameterReferenceKt;
import com.squareup.anvil.compiler.internal.reference.TopLevelFunctionReference;
import com.squareup.anvil.compiler.internal.reference.TypeReference;
import com.squareup.anvil.compiler.internal.reference.TypeReferenceKt;
import com.squareup.kotlinpoet.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002#$B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004J\u0010\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0004J\b\u0010!\u001a\u00020\u0010H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\"\u001a\u0004\u0018\u00010\u0014R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u0082\u0001\u0002%&\u00a8\u0006'"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/ParameterReference;", "Lcom/squareup/anvil/compiler/internal/reference/AnnotatedReference;", "()V", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "declaringFunction", "Lcom/squareup/anvil/compiler/internal/reference/FunctionReference;", "getDeclaringFunction", "()Lcom/squareup/anvil/compiler/internal/reference/FunctionReference;", "module", "Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "getModule", "()Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "name", "", "getName", "()Ljava/lang/String;", "type", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "getType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "equals", "", "other", "", "hashCode", "", "resolveTypeName", "Lcom/squareup/kotlinpoet/TypeName;", "implementingClass", "resolveTypeNameOrNull", "toString", "typeOrNull", "Descriptor", "Psi", "Lcom/squareup/anvil/compiler/internal/reference/ParameterReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/ParameterReference$Psi;", "compiler-utils"})
@ExperimentalAnvilApi
public abstract class ParameterReference
implements AnnotatedReference {
    private ParameterReference() {
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract FunctionReference getDeclaringFunction();

    @NotNull
    public final AnvilModuleDescriptor getModule() {
        return this.getDeclaringFunction().getModule();
    }

    @Nullable
    protected abstract TypeReference getType();

    @Nullable
    protected abstract ClassReference getDeclaringClass();

    @Nullable
    public final TypeReference typeOrNull() {
        return this.getType();
    }

    @NotNull
    public final TypeReference type() {
        TypeReference typeReference = this.getType();
        if (typeReference == null) {
            throw ParameterReferenceKt.AnvilCompilationExceptionParameterReference$default(this, "Unable to get type for the parameter with name " + this.getName() + " of function " + this.getDeclaringFunction().getFqName(), null, 4, null);
        }
        return typeReference;
    }

    @Nullable
    public final TypeName resolveTypeNameOrNull(@NotNull ClassReference implementingClass) {
        Intrinsics.checkNotNullParameter((Object)implementingClass, (String)"implementingClass");
        TypeReference typeReference = this.getType();
        return typeReference != null ? typeReference.resolveGenericTypeNameOrNull(implementingClass) : null;
    }

    @NotNull
    public final TypeName resolveTypeName(@NotNull ClassReference implementingClass) {
        Intrinsics.checkNotNullParameter((Object)implementingClass, (String)"implementingClass");
        TypeName typeName2 = this.resolveTypeNameOrNull(implementingClass);
        if (typeName2 == null) {
            String string = "Unable to resolve type name for parameter with name " + this.getName() + " with the implementing class " + implementingClass.getFqName() + '.';
            throw ParameterReferenceKt.AnvilCompilationExceptionParameterReference$default(this, string, null, 4, null);
        }
        return typeName2;
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName() + '(' + this.getDeclaringFunction().getFqName() + "(.., " + this.getName() + ",..))";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParameterReference)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)((ParameterReference)other).getName())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getDeclaringFunction(), (Object)((ParameterReference)other).getDeclaringFunction());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getDeclaringFunction().hashCode();
        return result;
    }

    @Override
    public boolean isAnnotatedWith(@NotNull FqName fqName) {
        return AnnotatedReference.DefaultImpls.isAnnotatedWith(this, fqName);
    }

    public /* synthetic */ ParameterReference(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\r\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/ParameterReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/ParameterReference;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "declaringFunction", "Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Descriptor;", "(Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Descriptor;)V", "annotations", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Descriptor;", "getAnnotations", "()Ljava/util/List;", "annotations$delegate", "Lkotlin/Lazy;", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;", "getDeclaringFunction", "()Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Descriptor;", "name", "", "getName", "()Ljava/lang/String;", "getParameter", "()Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "type", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Descriptor;", "getType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Descriptor;", "type$delegate", "compiler-utils"})
    public static final class Descriptor
    extends ParameterReference {
        @NotNull
        private final ValueParameterDescriptor parameter;
        @NotNull
        private final FunctionReference.Descriptor declaringFunction;
        @NotNull
        private final String name;
        @NotNull
        private final Lazy annotations$delegate;
        @NotNull
        private final Lazy type$delegate;

        public Descriptor(@NotNull ValueParameterDescriptor parameter, @NotNull FunctionReference.Descriptor declaringFunction) {
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            Intrinsics.checkNotNullParameter((Object)declaringFunction, (String)"declaringFunction");
            super(null);
            this.parameter = parameter;
            this.declaringFunction = declaringFunction;
            String string = this.parameter.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            this.name = string;
            this.annotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Descriptor>>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Descriptor> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = (Iterable)this.this$0.getParameter().getAnnotations();
                    Descriptor descriptor = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(AnnotationReferenceKt.toAnnotationReference((AnnotationDescriptor)it, null, (ModuleDescriptor)descriptor.getModule()));
                    }
                    return (List)destination$iv$iv;
                }
            }));
            this.type$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<TypeReference.Descriptor>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final TypeReference.Descriptor invoke() {
                    KotlinType kotlinType = this.this$0.getParameter().getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    return TypeReferenceKt.toTypeReference(kotlinType, this.this$0.getDeclaringClass(), this.this$0.getModule());
                }
            }));
        }

        @NotNull
        public final ValueParameterDescriptor getParameter() {
            return this.parameter;
        }

        @Override
        @NotNull
        public FunctionReference.Descriptor getDeclaringFunction() {
            return this.declaringFunction;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public List<AnnotationReference.Descriptor> getAnnotations() {
            Lazy lazy = this.annotations$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @Nullable
        protected TypeReference.Descriptor getType() {
            Lazy lazy = this.type$delegate;
            return (TypeReference.Descriptor)lazy.getValue();
        }

        @Override
        @Nullable
        protected ClassReference.Descriptor getDeclaringClass() {
            ClassReference.Descriptor descriptor;
            FunctionReference.Descriptor descriptor2 = this.getDeclaringFunction();
            if (descriptor2 instanceof TopLevelFunctionReference.Descriptor) {
                descriptor = null;
            } else if (descriptor2 instanceof MemberFunctionReference.Descriptor) {
                descriptor = ((MemberFunctionReference.Descriptor)this.getDeclaringFunction()).getDeclaringClass();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return descriptor;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\r\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/ParameterReference$Psi;", "Lcom/squareup/anvil/compiler/internal/reference/ParameterReference;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "declaringFunction", "Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Psi;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Psi;)V", "annotations", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Psi;", "getAnnotations", "()Ljava/util/List;", "annotations$delegate", "Lkotlin/Lazy;", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "getDeclaringFunction", "()Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Psi;", "name", "", "getName", "()Ljava/lang/String;", "getParameter", "()Lorg/jetbrains/kotlin/psi/KtParameter;", "type", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Psi;", "getType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Psi;", "type$delegate", "compiler-utils"})
    public static final class Psi
    extends ParameterReference {
        @NotNull
        private final KtParameter parameter;
        @NotNull
        private final FunctionReference.Psi declaringFunction;
        @NotNull
        private final String name;
        @NotNull
        private final Lazy annotations$delegate;
        @NotNull
        private final Lazy type$delegate;

        public Psi(@NotNull KtParameter parameter, @NotNull FunctionReference.Psi declaringFunction) {
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            Intrinsics.checkNotNullParameter((Object)declaringFunction, (String)"declaringFunction");
            super(null);
            this.parameter = parameter;
            this.declaringFunction = declaringFunction;
            String string = this.parameter.getNameAsSafeName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            this.name = string;
            this.annotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Psi>>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Psi> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list = this.this$0.getParameter().getAnnotationEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
                    Iterable iterable = list;
                    Psi psi = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(AnnotationReferenceKt.toAnnotationReference((KtAnnotationEntry)it, null, (ModuleDescriptor)psi.getModule()));
                    }
                    return (List)destination$iv$iv;
                }
            }));
            this.type$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<TypeReference.Psi>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final TypeReference.Psi invoke() {
                    KtTypeReference ktTypeReference = this.this$0.getParameter().getTypeReference();
                    return ktTypeReference != null ? TypeReferenceKt.toTypeReference(ktTypeReference, this.this$0.getDeclaringClass(), this.this$0.getModule()) : null;
                }
            }));
        }

        @NotNull
        public final KtParameter getParameter() {
            return this.parameter;
        }

        @Override
        @NotNull
        public FunctionReference.Psi getDeclaringFunction() {
            return this.declaringFunction;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public List<AnnotationReference.Psi> getAnnotations() {
            Lazy lazy = this.annotations$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @Nullable
        protected TypeReference.Psi getType() {
            Lazy lazy = this.type$delegate;
            return (TypeReference.Psi)lazy.getValue();
        }

        @Override
        @Nullable
        protected ClassReference.Psi getDeclaringClass() {
            ClassReference.Psi psi;
            FunctionReference.Psi psi2 = this.getDeclaringFunction();
            if (psi2 instanceof TopLevelFunctionReference.Psi) {
                psi = null;
            } else if (psi2 instanceof MemberFunctionReference.Psi) {
                psi = ((MemberFunctionReference.Psi)this.getDeclaringFunction()).getDeclaringClass();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return psi;
        }
    }
}

