/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler.internal.reference;

import com.squareup.anvil.annotations.ExperimentalAnvilApi;
import com.squareup.anvil.compiler.api.AnvilCompilationException;
import com.squareup.anvil.compiler.internal.FqNameKt;
import com.squareup.anvil.compiler.internal.PsiUtilsKt;
import com.squareup.anvil.compiler.internal.reference.AnnotationArgumentReference;
import com.squareup.anvil.compiler.internal.reference.AnnotationReference;
import com.squareup.anvil.compiler.internal.reference.ClassReference;
import com.squareup.anvil.compiler.internal.reference.ClassReferenceKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0001H\u0007\u001a\u001e\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u001a\u001e\u0010\u0012\u001a\u00020\u0019*\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"DEFAULT_SCOPE_INDEX", "", "AnvilCompilationExceptionAnnotationReference", "Lcom/squareup/anvil/compiler/api/AnvilCompilationException;", "annotationReference", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference;", "message", "", "cause", "", "excludeIndex", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "replacesIndex", "argumentAt", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationArgumentReference;", "name", "index", "toAnnotationReference", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Descriptor;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Psi;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "compiler-utils"})
@SourceDebugExtension(value={"SMAP\nAnnotationReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationReference.kt\ncom/squareup/anvil/compiler/internal/reference/AnnotationReferenceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n661#2,11:309\n1#3:320\n*S KotlinDebug\n*F\n+ 1 AnnotationReference.kt\ncom/squareup/anvil/compiler/internal/reference/AnnotationReferenceKt\n*L\n264#1:309,11\n*E\n"})
public final class AnnotationReferenceKt {
    private static final int DEFAULT_SCOPE_INDEX = 0;

    @ExperimentalAnvilApi
    @NotNull
    public static final AnnotationReference.Psi toAnnotationReference(@NotNull KtAnnotationEntry $this$toAnnotationReference, @Nullable ClassReference.Psi declaringClass, @NotNull ModuleDescriptor module) {
        Intrinsics.checkNotNullParameter((Object)$this$toAnnotationReference, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return new AnnotationReference.Psi($this$toAnnotationReference, ClassReferenceKt.toClassReference(PsiUtilsKt.requireFqName((PsiElement)$this$toAnnotationReference, module), module), declaringClass);
    }

    @ExperimentalAnvilApi
    @NotNull
    public static final AnnotationReference.Descriptor toAnnotationReference(@NotNull AnnotationDescriptor $this$toAnnotationReference, @Nullable ClassReference.Descriptor declaringClass, @NotNull ModuleDescriptor module) {
        Intrinsics.checkNotNullParameter((Object)$this$toAnnotationReference, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass((AnnotationDescriptor)$this$toAnnotationReference);
        if (classDescriptor == null) {
            throw new AnvilCompilationException("Couldn't find the annotation class for " + $this$toAnnotationReference.getFqName(), null, null, 6, null);
        }
        ClassDescriptor annotationClass = classDescriptor;
        return new AnnotationReference.Descriptor($this$toAnnotationReference, ClassReferenceKt.toClassReference(annotationClass, module), declaringClass);
    }

    @ExperimentalAnvilApi
    @Nullable
    public static final AnnotationArgumentReference argumentAt(@NotNull AnnotationReference $this$argumentAt, @NotNull String name, int index) {
        AnnotationArgumentReference annotationArgumentReference;
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$argumentAt, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$singleOrNull$iv = $this$argumentAt.getArguments();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                AnnotationArgumentReference it = (AnnotationArgumentReference)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                if (found$iv) {
                    v0 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        if ((annotationArgumentReference = (AnnotationArgumentReference)v0) == null) {
            AnnotationArgumentReference annotationArgumentReference2 = (AnnotationArgumentReference)CollectionsKt.getOrNull($this$argumentAt.getArguments(), (int)index);
            if (annotationArgumentReference2 != null) {
                AnnotationArgumentReference annotationArgumentReference3;
                AnnotationArgumentReference it = annotationArgumentReference3 = annotationArgumentReference2;
                boolean bl = false;
                annotationArgumentReference = it.getName() == null ? annotationArgumentReference3 : null;
            } else {
                annotationArgumentReference = null;
            }
        }
        return annotationArgumentReference;
    }

    @ExperimentalAnvilApi
    @NotNull
    public static final AnvilCompilationException AnvilCompilationExceptionAnnotationReference(@NotNull AnnotationReference annotationReference, @NotNull String message, @Nullable Throwable cause) {
        AnvilCompilationException anvilCompilationException;
        Intrinsics.checkNotNullParameter((Object)annotationReference, (String)"annotationReference");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        AnnotationReference annotationReference2 = annotationReference;
        if (annotationReference2 instanceof AnnotationReference.Psi) {
            KtAnnotationEntry ktAnnotationEntry = ((AnnotationReference.Psi)annotationReference).getAnnotation();
            anvilCompilationException = new AnvilCompilationException(message, cause, (PsiElement)ktAnnotationEntry);
        } else if (annotationReference2 instanceof AnnotationReference.Descriptor) {
            anvilCompilationException = AnvilCompilationException.Companion.invoke(((AnnotationReference.Descriptor)annotationReference).getAnnotation(), message, cause);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return anvilCompilationException;
    }

    public static /* synthetic */ AnvilCompilationException AnvilCompilationExceptionAnnotationReference$default(AnnotationReference annotationReference, String string, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        return AnnotationReferenceKt.AnvilCompilationExceptionAnnotationReference(annotationReference, string, throwable);
    }

    private static final int replacesIndex(FqName annotationFqName) {
        int n;
        FqName fqName = annotationFqName;
        if (Intrinsics.areEqual((Object)fqName, (Object)FqNameKt.getContributesToFqName())) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)fqName, (Object)FqNameKt.getContributesBindingFqName()) ? true : Intrinsics.areEqual((Object)fqName, (Object)FqNameKt.getContributesMultibindingFqName())) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)fqName, (Object)FqNameKt.getContributesSubcomponentFqName())) {
            n = 4;
        } else {
            throw new NotImplementedError("Couldn't find index of replaces argument for " + annotationFqName + '.');
        }
        return n;
    }

    private static final int excludeIndex(FqName annotationFqName) {
        int n;
        FqName fqName = annotationFqName;
        if (Intrinsics.areEqual((Object)fqName, (Object)FqNameKt.getMergeInterfacesFqName())) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)fqName, (Object)FqNameKt.getMergeSubcomponentFqName())) {
            n = 2;
        } else if ((Intrinsics.areEqual((Object)fqName, (Object)FqNameKt.getMergeComponentFqName()) ? true : Intrinsics.areEqual((Object)fqName, (Object)FqNameKt.getMergeModulesFqName())) ? true : Intrinsics.areEqual((Object)fqName, (Object)FqNameKt.getContributesSubcomponentFqName())) {
            n = 3;
        } else {
            throw new NotImplementedError("Couldn't find index of exclude argument for " + annotationFqName + '.');
        }
        return n;
    }

    public static final /* synthetic */ int access$replacesIndex(FqName annotationFqName) {
        return AnnotationReferenceKt.replacesIndex(annotationFqName);
    }

    public static final /* synthetic */ int access$excludeIndex(FqName annotationFqName) {
        return AnnotationReferenceKt.excludeIndex(annotationFqName);
    }
}

