/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.google.common.collect.ImmutableMap;
import com.spotify.folsom.MemcachedStats;
import com.spotify.folsom.client.AllRequest;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatsRequest
extends BinaryRequest<Map<String, MemcachedStats>>
implements AllRequest<Map<String, MemcachedStats>> {
    public StatsRequest(String key) {
        super(key.getBytes(StandardCharsets.US_ASCII));
    }

    private StatsRequest(byte[] key) {
        super(key);
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        this.writeHeader(dst, OpCode.STAT, 0, 0, 0L);
        dst.put(this.key);
        return StatsRequest.toBuffer(alloc, dst);
    }

    @Override
    public void handle(BinaryResponse replies, HostAndPort server) throws IOException {
        HashMap<String, String> stats = new HashMap<String, String>();
        int expectedOpaque = this.opaque;
        for (ResponsePacket reply : replies) {
            if (OpCode.getKind(reply.opcode) != OpCode.STAT) {
                throw new IOException("Unmatched response");
            }
            int opaque = reply.opaque;
            if (opaque != expectedOpaque) {
                throw new IOException("messages out of order for " + this.getClass().getSimpleName());
            }
            for (ResponsePacket responsePacket : replies) {
                String name = new String(responsePacket.key, StandardCharsets.US_ASCII);
                String value = new String(responsePacket.value, StandardCharsets.US_ASCII);
                stats.put(name, value);
            }
        }
        this.succeed(ImmutableMap.of((Object)(server.getHostText() + ":" + server.getPort()), (Object)new MemcachedStats(stats)));
    }

    @Override
    public Map<String, MemcachedStats> merge(List<Map<String, MemcachedStats>> results) {
        return AllRequest.mergeStats(results);
    }

    @Override
    public Request<Map<String, MemcachedStats>> duplicate() {
        return new StatsRequest(this.key);
    }
}

