/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.AllRequest;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class FlushRequest
extends BinaryRequest<MemcacheStatus>
implements AllRequest<MemcacheStatus> {
    public static final byte[] NO_KEY = new byte[0];
    private final int delay;

    public FlushRequest(int delay) {
        super(NO_KEY);
        this.delay = delay;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        int expiration = Utils.ttlToExpiration(this.delay);
        int extrasLength = 4;
        this.writeHeader(dst, OpCode.FLUSH, 4, 0, 0L);
        dst.putInt(expiration);
        return FlushRequest.toBuffer(alloc, dst);
    }

    @Override
    public void handle(BinaryResponse replies, HostAndPort server) throws IOException {
        ResponsePacket reply = this.handleSingleReply(replies);
        this.succeed(reply.status);
    }

    @Override
    public MemcacheStatus merge(List<MemcacheStatus> results) {
        return AllRequest.mergeMemcacheStatus(results);
    }

    @Override
    public Request<MemcacheStatus> duplicate() {
        return new FlushRequest(this.delay);
    }
}

