/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.google.common.collect.Lists;
import com.spotify.folsom.BinaryMemcacheClient;
import com.spotify.folsom.ConnectionChangeListener;
import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.MemcachedStats;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.Tracer;
import com.spotify.folsom.Transcoder;
import com.spotify.folsom.client.AbstractRequest;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.TransformerUtil;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.binary.DeleteAllRequest;
import com.spotify.folsom.client.binary.DeleteRequest;
import com.spotify.folsom.client.binary.FlushRequest;
import com.spotify.folsom.client.binary.GetRequest;
import com.spotify.folsom.client.binary.IncrRequest;
import com.spotify.folsom.client.binary.MultigetRequest;
import com.spotify.folsom.client.binary.NoopRequest;
import com.spotify.folsom.client.binary.SetRequest;
import com.spotify.folsom.client.binary.StatsRequest;
import com.spotify.folsom.client.binary.TouchRequest;
import com.spotify.futures.CompletableFutures;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public class DefaultBinaryMemcacheClient<V>
implements BinaryMemcacheClient<V> {
    private final RawMemcacheClient rawMemcacheClient;
    private final Metrics metrics;
    private final Tracer tracer;
    private final Transcoder<V> valueTranscoder;
    private final TransformerUtil<V> transformerUtil;
    private final int maxKeyLength;
    private final Charset charset;

    private DefaultBinaryMemcacheClient(RawMemcacheClient rawMemcacheClient, Metrics metrics, Tracer tracer, Transcoder<V> valueTranscoder, TransformerUtil<V> transformerUtil, Charset charset, int maxKeyLength) {
        this.rawMemcacheClient = rawMemcacheClient;
        this.metrics = metrics;
        this.tracer = tracer;
        this.valueTranscoder = valueTranscoder;
        this.charset = charset;
        this.transformerUtil = transformerUtil;
        this.maxKeyLength = maxKeyLength;
    }

    public DefaultBinaryMemcacheClient(RawMemcacheClient rawMemcacheClient, Metrics metrics, Tracer tracer, Transcoder<V> valueTranscoder, Charset charset, int maxKeyLength) {
        this(rawMemcacheClient, metrics, tracer, valueTranscoder, new TransformerUtil<V>(valueTranscoder), charset, maxKeyLength);
    }

    @Override
    public CompletionStage<MemcacheStatus> set(String key, V value, int ttl) {
        return this.setInternal(OpCode.SET, key, value, ttl, 0);
    }

    @Override
    public CompletionStage<MemcacheStatus> set(String key, V value, int ttl, int flags) {
        return this.setInternal(OpCode.SET, key, value, ttl, flags);
    }

    @Override
    public CompletionStage<MemcacheStatus> set(String key, V value, int ttl, long cas) {
        return this.casSetInternal(OpCode.SET, key, value, ttl, cas, 0);
    }

    @Override
    public CompletionStage<MemcacheStatus> set(String key, V value, int ttl, long cas, int flags) {
        return this.casSetInternal(OpCode.SET, key, value, ttl, cas, flags);
    }

    @Override
    public CompletionStage<MemcacheStatus> add(String key, V value, int ttl) {
        return this.setInternal(OpCode.ADD, key, value, ttl, 0);
    }

    @Override
    public CompletionStage<MemcacheStatus> add(String key, V value, int ttl, int flags) {
        return this.setInternal(OpCode.ADD, key, value, ttl, flags);
    }

    @Override
    public CompletionStage<MemcacheStatus> replace(String key, V value, int ttl) {
        return this.replace(key, value, ttl, 0);
    }

    @Override
    public CompletionStage<MemcacheStatus> replace(String key, V value, int ttl, int flags) {
        return this.setInternal(OpCode.REPLACE, key, value, ttl, flags);
    }

    private CompletionStage<MemcacheStatus> setInternal(OpCode opcode, String key, V value, int ttl, int flags) {
        return this.casSetInternal(opcode, key, value, ttl, 0L, flags);
    }

    @Override
    public CompletionStage<MemcacheStatus> add(String key, V value, int ttl, long cas) {
        return this.casSetInternal(OpCode.ADD, key, value, ttl, cas, 0);
    }

    @Override
    public CompletionStage<MemcacheStatus> add(String key, V value, int ttl, long cas, int flags) {
        return this.casSetInternal(OpCode.ADD, key, value, ttl, cas, flags);
    }

    @Override
    public CompletionStage<MemcacheStatus> replace(String key, V value, int ttl, long cas) {
        return this.casSetInternal(OpCode.REPLACE, key, value, ttl, cas, 0);
    }

    @Override
    public CompletionStage<MemcacheStatus> replace(String key, V value, int ttl, long cas, int flags) {
        return this.casSetInternal(OpCode.REPLACE, key, value, ttl, cas, flags);
    }

    private CompletionStage<MemcacheStatus> casSetInternal(OpCode opcode, String key, V value, int ttl, long cas, int flags) {
        Objects.requireNonNull(value);
        byte[] valueBytes = this.valueTranscoder.encode(value);
        SetRequest request = new SetRequest(opcode, AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), valueBytes, ttl, cas, flags);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureSetFuture(future);
        this.trace(opcode, key, valueBytes, future);
        return future;
    }

    @Override
    public CompletionStage<V> get(String key) {
        return this.getAndTouch(key, -1);
    }

    @Override
    public CompletionStage<V> getAndTouch(String key, int ttl) {
        return this.transformerUtil.unwrap(this.casGetAndTouch(key, ttl));
    }

    @Override
    public CompletionStage<List<V>> get(List<String> keys) {
        return this.getAndTouch(keys, -1);
    }

    @Override
    public CompletionStage<GetResult<V>> casGet(String key) {
        return this.getInternal(key, -1);
    }

    private CompletionStage<GetResult<V>> getInternal(String key, int ttl) {
        OpCode opCode = ttl > -1 ? OpCode.GAT : OpCode.GET;
        GetRequest request = new GetRequest(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), opCode, ttl);
        CompletionStage<GetResult<byte[]>> future = this.rawMemcacheClient.send(request);
        this.metrics.measureGetFuture(future);
        this.trace(opCode, key, null, future);
        return this.transformerUtil.decode(future);
    }

    @Override
    public CompletionStage<List<GetResult<V>>> casGet(List<String> keys) {
        List<byte[]> byteKeys = AbstractRequest.encodeKeys(keys, this.charset, this.maxKeyLength);
        return this.multiget(byteKeys, -1);
    }

    private CompletionStage<List<GetResult<V>>> multiget(List<byte[]> keys, int ttl) {
        int size = keys.size();
        if (size == 0) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List keyPartition = Lists.partition(keys, (int)255);
        ArrayList<CompletionStage<List<GetResult<byte[]>>>> futureList = new ArrayList<CompletionStage<List<GetResult<byte[]>>>>(keyPartition.size());
        for (List part : keyPartition) {
            MultigetRequest request = MultigetRequest.create(part, ttl);
            futureList.add(this.rawMemcacheClient.send(request));
        }
        CompletionStage future = CompletableFutures.allAsList(futureList).thenApply(Utils.flatten());
        this.metrics.measureMultigetFuture(future);
        this.trace(OpCode.GET, null, null, future);
        return this.transformerUtil.decodeList(future);
    }

    @Override
    public CompletionStage<List<V>> getAndTouch(List<String> keys, int ttl) {
        List<byte[]> byteKeys = AbstractRequest.encodeKeys(keys, this.charset, this.maxKeyLength);
        return this.transformerUtil.unwrapList(this.multiget(byteKeys, ttl));
    }

    @Override
    public CompletionStage<GetResult<V>> casGetAndTouch(String key, int ttl) {
        return this.getInternal(key, ttl);
    }

    @Override
    public CompletionStage<MemcacheStatus> touch(String key, int ttl) {
        TouchRequest request = new TouchRequest(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), ttl);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureTouchFuture(future);
        this.trace(OpCode.TOUCH, key, null, future);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> flushAll(int delay) {
        return this.rawMemcacheClient.send(new FlushRequest(delay));
    }

    @Override
    public CompletionStage<MemcacheStatus> delete(String key) {
        DeleteRequest request = new DeleteRequest(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), 0L);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureDeleteFuture(future);
        this.trace(OpCode.DELETE, key, null, future);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> delete(String key, long cas) {
        DeleteRequest request = new DeleteRequest(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), cas);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureDeleteFuture(future);
        this.trace(OpCode.DELETE, key, null, future);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> deleteAll(String key) {
        DeleteAllRequest request = new DeleteAllRequest(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength));
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureDeleteFuture(future);
        this.trace(OpCode.DELETE, key, null, future);
        return future;
    }

    @Override
    public CompletionStage<Long> incr(String key, long by, long initial, int ttl) {
        return this.incrInternal(OpCode.INCREMENT, key, by, initial, ttl);
    }

    private CompletionStage<Long> incrInternal(OpCode opcode, String key, long by, long initial, int ttl) {
        CompletionStage<Long> future = this.rawMemcacheClient.send(new IncrRequest(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), opcode, by, initial, ttl));
        this.metrics.measureIncrDecrFuture(future);
        this.trace(opcode, key, null, future);
        return future;
    }

    @Override
    public CompletionStage<Long> decr(String key, long by, long initial, int ttl) {
        return this.incrInternal(OpCode.DECREMENT, key, by, initial, ttl);
    }

    @Override
    public CompletionStage<MemcacheStatus> append(String key, V value) {
        return this.casSetInternal(OpCode.APPEND, key, value, 0, 0L, 0);
    }

    @Override
    public CompletionStage<MemcacheStatus> append(String key, V value, long cas) {
        return this.casSetInternal(OpCode.APPEND, key, value, 0, cas, 0);
    }

    @Override
    public CompletionStage<MemcacheStatus> prepend(String key, V value) {
        return this.casSetInternal(OpCode.PREPEND, key, value, 0, 0L, 0);
    }

    @Override
    public CompletionStage<MemcacheStatus> prepend(String key, V value, long cas) {
        return this.casSetInternal(OpCode.PREPEND, key, value, 0, cas, 0);
    }

    @Override
    public CompletionStage<Void> noop() {
        return this.rawMemcacheClient.send(new NoopRequest());
    }

    @Override
    public void shutdown() {
        this.rawMemcacheClient.shutdown();
    }

    @Override
    public void registerForConnectionChanges(ConnectionChangeListener listener) {
        this.rawMemcacheClient.registerForConnectionChanges(listener);
    }

    @Override
    public void unregisterForConnectionChanges(ConnectionChangeListener listener) {
        this.rawMemcacheClient.unregisterForConnectionChanges(listener);
    }

    @Override
    public void notifyConnectionChange() {
        this.rawMemcacheClient.notifyConnectionChange();
    }

    @Override
    public boolean isConnected() {
        return this.rawMemcacheClient.isConnected();
    }

    @Override
    public Throwable getConnectionFailure() {
        return this.rawMemcacheClient.getConnectionFailure();
    }

    @Override
    public int numTotalConnections() {
        return this.rawMemcacheClient.numTotalConnections();
    }

    @Override
    public int numActiveConnections() {
        return this.rawMemcacheClient.numActiveConnections();
    }

    @Override
    public RawMemcacheClient getRawMemcacheClient() {
        return this.rawMemcacheClient;
    }

    @Override
    public Map<String, BinaryMemcacheClient<V>> getAllNodes() {
        return this.rawMemcacheClient.getAllNodes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.withClient((RawMemcacheClient)entry.getValue())));
    }

    private DefaultBinaryMemcacheClient<V> withClient(RawMemcacheClient client) {
        return new DefaultBinaryMemcacheClient<V>(client, this.metrics, this.tracer, this.valueTranscoder, this.transformerUtil, this.charset, this.maxKeyLength);
    }

    @Override
    public CompletionStage<Map<String, MemcachedStats>> getStats(String key) {
        return this.rawMemcacheClient.send(new StatsRequest(key));
    }

    private void trace(OpCode opcode, String key, byte[] value, CompletionStage<?> future) {
        String operationName = opcode.name().toLowerCase();
        String spanName = "folsom." + operationName;
        if (key != null) {
            if (value != null) {
                this.tracer.span(spanName, future, operationName, key, value);
            } else {
                this.tracer.span(spanName, future, operationName, key);
            }
        } else {
            this.tracer.span(spanName, future, operationName);
        }
    }

    public String toString() {
        return "BinaryMemcacheClient(" + this.rawMemcacheClient + ")";
    }
}

