/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.client.AbstractRequest;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import com.spotify.folsom.guava.HostAndPort;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;

public abstract class BinaryRequest<V>
extends AbstractRequest<V> {
    protected static final int HEADER_SIZE = 24;
    protected static final byte MAGIC_NUMBER = -128;
    protected final int opaque = ThreadLocalRandom.current().nextInt() << 8 & 0xFFFFFF00;

    protected BinaryRequest(byte[] key) {
        super(key);
    }

    public void writeHeader(ByteBuffer dst, OpCode opCode, int extraLength, int valueLength, long cas) {
        int keyLength = this.key.length;
        dst.put((byte)-128);
        dst.put(opCode.value());
        dst.putShort((short)keyLength);
        dst.put((byte)extraLength);
        dst.put((byte)0);
        dst.put((byte)0);
        dst.put((byte)0);
        dst.putInt(extraLength + keyLength + valueLength);
        dst.putInt(this.opaque);
        dst.putLong(cas);
    }

    protected ResponsePacket handleSingleReply(BinaryResponse replies) throws IOException {
        if (replies.size() != 1) {
            throw new IOException("got " + replies.size() + " replies but expected 1 for " + this.getClass().getSimpleName());
        }
        ResponsePacket reply = (ResponsePacket)replies.get(0);
        if (reply.opaque != this.opaque) {
            throw new IOException("messages out of order for " + this.getClass().getSimpleName());
        }
        return reply;
    }

    @Override
    public void handle(Object response, HostAndPort server) throws IOException {
        this.handle((BinaryResponse)response, server);
    }

    protected abstract void handle(BinaryResponse var1, HostAndPort var2) throws IOException;
}

