/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.spotify.folsom.MemcacheAuthenticationException;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TouchRequest
extends AsciiRequest<MemcacheStatus> {
    private static final byte[] CMD = "touch ".getBytes();
    private final int ttl;

    public TouchRequest(byte[] key, int ttl) {
        super(key);
        this.ttl = ttl;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(CMD);
        dst.put(this.key);
        dst.put((byte)32);
        dst.put(String.valueOf(Utils.ttlToExpiration(this.ttl)).getBytes());
        dst.put(NEWLINE_BYTES);
        return TouchRequest.toBuffer(alloc, dst);
    }

    @Override
    public Request<MemcacheStatus> duplicate() {
        return new TouchRequest(this.key, this.ttl);
    }

    @Override
    protected void handle(AsciiResponse response, HostAndPort server) throws IOException {
        AsciiResponse.Type type = response.type;
        if (type == AsciiResponse.Type.TOUCHED) {
            this.succeed(MemcacheStatus.OK);
        } else if (type == AsciiResponse.Type.NOT_FOUND) {
            this.succeed(MemcacheStatus.KEY_NOT_FOUND);
        } else if (type == AsciiResponse.Type.CLIENT_ERROR) {
            MemcacheAuthenticationException exception = new MemcacheAuthenticationException("Authentication required by server. Client not authenticated.");
            this.fail(exception, server);
        } else {
            throw new IOException("Unexpected line: " + (Object)((Object)type));
        }
    }
}

