/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.spotify.folsom.MemcacheAuthenticationException;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;

public class SetRequest
extends AsciiRequest<MemcacheStatus>
implements com.spotify.folsom.client.SetRequest {
    private static final EnumMap<Operation, byte[]> CMD;
    private static final byte[] NO_FLAGS;
    private final Operation operation;
    private final byte[] value;
    private final int ttl;
    private final long cas;
    private final int flags;

    SetRequest(Operation operation, byte[] key, byte[] value, int ttl, long cas, int flags) {
        super(key);
        this.operation = operation;
        this.value = value;
        this.ttl = ttl;
        this.cas = cas;
        this.flags = flags;
    }

    public static SetRequest casSet(byte[] key, byte[] value, int ttl, long cas) {
        return SetRequest.casSet(key, value, ttl, cas, 0);
    }

    public static SetRequest casSet(byte[] key, byte[] value, int ttl, long cas, int flags) {
        return new SetRequest(Operation.CAS, key, value, ttl, cas, flags);
    }

    public static SetRequest create(Operation operation, byte[] key, byte[] value, int ttl) {
        return SetRequest.create(operation, key, value, ttl, 0);
    }

    public static SetRequest create(Operation operation, byte[] key, byte[] value, int ttl, int flags) {
        if (operation == null || operation == Operation.CAS) {
            throw new IllegalArgumentException("Invalid operation: " + (Object)((Object)operation));
        }
        return new SetRequest(operation, key, value, ttl, 0L, flags);
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(CMD.get((Object)this.operation));
        dst.put(this.key);
        dst.put(SetRequest.toFlags(this.flags));
        dst.put(String.valueOf(Utils.ttlToExpiration(this.ttl)).getBytes());
        dst.put((byte)32);
        dst.put(String.valueOf(this.value.length).getBytes());
        if (this.operation == Operation.CAS) {
            dst.put((byte)32);
            dst.put(String.valueOf(this.cas).getBytes());
        }
        dst.put(NEWLINE_BYTES);
        if (dst.remaining() >= this.value.length + NEWLINE_BYTES.length) {
            dst.put(this.value);
            dst.put(NEWLINE_BYTES);
            return SetRequest.toBuffer(alloc, dst);
        }
        return SetRequest.toBufferWithValueAndNewLine(alloc, dst, this.value);
    }

    @Override
    public Request<MemcacheStatus> duplicate() {
        return new SetRequest(this.operation, this.key, this.value, this.ttl, this.cas, this.flags);
    }

    private static ByteBuf toBufferWithValueAndNewLine(ByteBufAllocator alloc, ByteBuffer dst, byte[] value) {
        ByteBuf buffer = SetRequest.toBuffer(alloc, dst, value.length + NEWLINE_BYTES.length);
        buffer.writeBytes(value);
        buffer.writeBytes(NEWLINE_BYTES);
        return buffer;
    }

    private static byte[] toFlags(int flags) {
        if (flags == 0) {
            return NO_FLAGS;
        }
        return (" " + flags + " ").getBytes(StandardCharsets.US_ASCII);
    }

    @Override
    public void handle(AsciiResponse response, HostAndPort server) throws IOException {
        switch (response.type) {
            case STORED: {
                this.succeed(MemcacheStatus.OK);
                return;
            }
            case NOT_STORED: {
                this.succeed(MemcacheStatus.ITEM_NOT_STORED);
                return;
            }
            case VALUE_TOO_LARGE: {
                this.succeed(MemcacheStatus.VALUE_TOO_LARGE);
                return;
            }
            case OUT_OF_MEMORY: {
                this.succeed(MemcacheStatus.OUT_OF_MEMORY);
                return;
            }
            case EXISTS: {
                this.succeed(MemcacheStatus.KEY_EXISTS);
                return;
            }
            case NOT_FOUND: {
                if (this.operation == Operation.APPEND || this.operation == Operation.PREPEND) {
                    this.succeed(MemcacheStatus.ITEM_NOT_STORED);
                } else {
                    this.succeed(MemcacheStatus.KEY_NOT_FOUND);
                }
                return;
            }
            case CLIENT_ERROR: {
                MemcacheAuthenticationException exception = new MemcacheAuthenticationException("Authentication required by server. Client not authenticated.");
                this.fail(exception, server);
                return;
            }
        }
        throw new IOException("Unexpected line: " + (Object)((Object)response.type));
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public OpCode getOpCode() {
        switch (this.operation) {
            case ADD: {
                return OpCode.ADD;
            }
            case REPLACE: {
                return OpCode.REPLACE;
            }
            case APPEND: {
                return OpCode.APPEND;
            }
            case PREPEND: {
                return OpCode.PREPEND;
            }
        }
        return OpCode.SET;
    }

    @Override
    public boolean withCas() {
        return this.operation.equals((Object)Operation.CAS) && this.cas != 0L;
    }

    static {
        NO_FLAGS = " 0 ".getBytes(StandardCharsets.US_ASCII);
        CMD = new EnumMap(Operation.class);
        CMD.put(Operation.SET, "set ".getBytes(StandardCharsets.US_ASCII));
        CMD.put(Operation.ADD, "add ".getBytes(StandardCharsets.US_ASCII));
        CMD.put(Operation.REPLACE, "replace ".getBytes(StandardCharsets.US_ASCII));
        CMD.put(Operation.APPEND, "append ".getBytes(StandardCharsets.US_ASCII));
        CMD.put(Operation.PREPEND, "prepend ".getBytes(StandardCharsets.US_ASCII));
        CMD.put(Operation.CAS, "cas ".getBytes(StandardCharsets.US_ASCII));
    }

    public static enum Operation {
        SET,
        ADD,
        REPLACE,
        APPEND,
        PREPEND,
        CAS;

    }
}

