/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheAuthenticationException;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.client.ascii.ValueAsciiResponse;
import com.spotify.folsom.client.ascii.ValueResponse;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class GetRequest
extends AsciiRequest<GetResult<byte[]>>
implements com.spotify.folsom.client.GetRequest {
    private static final byte[] GET = "get ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CAS_GET = "gets ".getBytes(StandardCharsets.US_ASCII);
    private final byte[] cmd;

    public GetRequest(byte[] key, boolean withCas) {
        super(key);
        this.cmd = withCas ? CAS_GET : GET;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(this.cmd);
        dst.put(this.key);
        dst.put(NEWLINE_BYTES);
        return GetRequest.toBuffer(alloc, dst);
    }

    @Override
    public Request<GetResult<byte[]>> duplicate() {
        return new GetRequest(this.key, this.cmd == CAS_GET);
    }

    @Override
    public void handle(AsciiResponse response, HostAndPort server) throws IOException {
        if (response.type == AsciiResponse.Type.EMPTY_LIST) {
            this.succeed(null);
            return;
        }
        if (response.type == AsciiResponse.Type.CLIENT_ERROR) {
            MemcacheAuthenticationException exception = new MemcacheAuthenticationException("Authentication required by server. Client not authenticated.");
            this.fail(exception, server);
            return;
        }
        if (!(response instanceof ValueAsciiResponse)) {
            throw new IOException("Unexpected response type: " + (Object)((Object)response.type));
        }
        List<ValueResponse> values = ((ValueAsciiResponse)response).values;
        if (values.size() > 1) {
            throw new IOException("Too many responses, expected 1 but got " + values.size());
        }
        ValueResponse valueResponse = values.get(0);
        if (!Arrays.equals(valueResponse.key, this.key)) {
            String message = "Expected key " + this.decodeKey(this.key) + " but got " + this.decodeKey(valueResponse.key);
            throw new IOException(message);
        }
        this.succeed(GetResult.success(valueResponse.value, valueResponse.cas, valueResponse.flags));
    }

    private String decodeKey(byte[] key1) {
        return new String(key1, StandardCharsets.US_ASCII);
    }
}

