/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import java.util.EnumSet;

public enum OpCode {
    GET(0),
    SET(1),
    ADD(2),
    REPLACE(3),
    DELETE(4),
    INCREMENT(5),
    DECREMENT(6),
    QUIT(7),
    FLUSH(8),
    GETQ(9),
    NOOP(10),
    VERSION(11),
    GETK(12),
    GETKQ(13),
    APPEND(14),
    PREPEND(15),
    STAT(16),
    SETQ(17),
    ADDQ(18),
    REPLACEQ(19),
    DELETEQ(20),
    INCREMENTQ(21),
    DECREMENTQ(22),
    QUITQ(23),
    FLUSHQ(24),
    APPENDQ(25),
    PREPANDQ(26),
    VERBOSITY(27),
    TOUCH(28),
    GAT(29),
    GATQ(30),
    SASL_LIST_MECHS(32),
    SASL_AUTH(33),
    SASL_STEP(34),
    RGET(48),
    RSET(49),
    RSETQ(50),
    RAPPEND(51),
    RAPPENDQ(52),
    RPREPEND(53),
    RPREPENDQ(54),
    RDELETE(55),
    RDELETEQ(56),
    RINCR(57),
    RINCRQ(58),
    RDECR(59),
    RDECRQ(60),
    SET_VBUCKET(61),
    GET_VBUCKET(62),
    DEL_VBUCKET(63),
    TAP_MUTATION(65),
    TAP_DELETE(66),
    TAP_FLUSH(67),
    TAP_OPAQUE(68),
    TAP_VBUCKET_SET(69),
    TAP_CHECKPOINT_START(70),
    TAP_CHECKPOINT_END(71);

    private static final OpCode[] BY_VALUE;
    private final byte opcode;

    public static OpCode of(byte value) {
        OpCode opCode;
        if (value >= 0 && value < BY_VALUE.length && (opCode = BY_VALUE[value]) != null) {
            return opCode;
        }
        throw new IllegalArgumentException("Unknown opcode: " + value);
    }

    public static OpCode getKind(OpCode opcode) {
        switch (opcode) {
            case GET: 
            case GETQ: 
            case GAT: {
                return GET;
            }
            case SET: 
            case APPEND: 
            case PREPEND: 
            case ADD: 
            case REPLACE: 
            case DELETE: {
                return SET;
            }
        }
        return opcode;
    }

    private OpCode(int opcode) {
        this.opcode = (byte)opcode;
    }

    public byte value() {
        return this.opcode;
    }

    static {
        BY_VALUE = new OpCode[OpCode.TAP_CHECKPOINT_END.opcode + 1];
        EnumSet<OpCode> all = EnumSet.allOf(OpCode.class);
        all.stream().forEach(opCode -> {
            OpCode.BY_VALUE[opCode.opcode] = opCode;
        });
    }
}

