/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import com.spotify.folsom.client.Request;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public abstract class AbstractRequest<V>
extends CompletableFuture<V>
implements Request<V> {
    protected final byte[] key;

    protected AbstractRequest(byte[] key) {
        this.key = key;
    }

    protected static ByteBuf toBuffer(ByteBufAllocator alloc, ByteBuffer dst) {
        return AbstractRequest.toBuffer(alloc, dst, 0);
    }

    @Override
    public byte[] getKey() {
        return this.key;
    }

    @Override
    public void fail(Throwable e, HostAndPort address) {
        this.completeExceptionally(e);
    }

    @Override
    public CompletionStage<V> asFuture() {
        return this;
    }

    public void succeed(V result) {
        this.complete(result);
    }

    protected static ByteBuf toBuffer(ByteBufAllocator alloc, ByteBuffer dst, int extra) {
        dst.flip();
        ByteBuf buffer = alloc.buffer(dst.remaining() + extra);
        buffer.writeBytes(dst);
        return buffer;
    }

    public static byte[] encodeKey(String key, Charset charset, int maxKeyLength) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(charset, "charset");
        byte[] keyBytes = key.getBytes(charset);
        int length = keyBytes.length;
        if (length > maxKeyLength) {
            String message = "Key is too long. Max-length is " + maxKeyLength + " but key was " + length + ": " + key;
            throw new IllegalArgumentException(message);
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Key is empty");
        }
        for (int i = 0; i < length; ++i) {
            byte c = keyBytes[i];
            if (c < 0 || c > 32) continue;
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        return keyBytes;
    }

    public static List<byte[]> encodeKeys(List<String> keys, Charset charset, int maxKeyLength) {
        ArrayList<byte[]> res = new ArrayList<byte[]>(keys.size());
        for (String key : keys) {
            res.add(AbstractRequest.encodeKey(key, charset, maxKeyLength));
        }
        return res;
    }
}

