/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class AuthorizationResponse
implements Parcelable {
    private final Type mType;
    private final String mCode;
    private final String mAccessToken;
    private final String mState;
    private final String mError;
    private final int mExpiresIn;
    @Nullable
    private final String mRefreshToken;
    public static final Parcelable.Creator<AuthorizationResponse> CREATOR = new Parcelable.Creator<AuthorizationResponse>(){

        @NonNull
        public AuthorizationResponse createFromParcel(@NonNull Parcel source) {
            return new AuthorizationResponse(source);
        }

        @NonNull
        public AuthorizationResponse[] newArray(int size) {
            return new AuthorizationResponse[size];
        }
    };

    private AuthorizationResponse(Type type, String code, String accessToken, String state, String error, int expiresIn, String refreshToken) {
        this.mType = type != null ? type : Type.UNKNOWN;
        this.mCode = code;
        this.mAccessToken = accessToken;
        this.mState = state;
        this.mError = error;
        this.mExpiresIn = expiresIn;
        this.mRefreshToken = refreshToken;
    }

    public AuthorizationResponse(@NonNull Parcel source) {
        this.mExpiresIn = source.readInt();
        this.mError = source.readString();
        this.mState = source.readString();
        this.mAccessToken = source.readString();
        this.mCode = source.readString();
        this.mType = Type.values()[source.readInt()];
        this.mRefreshToken = source.readString();
    }

    @NonNull
    public static AuthorizationResponse fromUri(@Nullable Uri uri) {
        Builder builder = new Builder();
        if (uri == null) {
            builder.setType(Type.EMPTY);
            return builder.build();
        }
        String possibleError = uri.getQueryParameter("error");
        if (possibleError != null) {
            String state = uri.getQueryParameter("state");
            builder.setError(possibleError);
            builder.setState(state);
            builder.setType(Type.ERROR);
            return builder.build();
        }
        String possibleCode = uri.getQueryParameter("code");
        if (possibleCode != null) {
            String state = uri.getQueryParameter("state");
            builder.setCode(possibleCode);
            builder.setState(state);
            builder.setType(Type.CODE);
            return builder.build();
        }
        String possibleImplicit = uri.getEncodedFragment();
        if (possibleImplicit != null && possibleImplicit.length() > 0) {
            String[] parts = possibleImplicit.split("&");
            String accessToken = null;
            String state = null;
            String expiresIn = null;
            for (String part : parts) {
                String[] partSplit = part.split("=");
                if (partSplit.length != 2) continue;
                if (partSplit[0].startsWith("access_token")) {
                    accessToken = Uri.decode((String)partSplit[1]);
                }
                if (partSplit[0].startsWith("state")) {
                    state = Uri.decode((String)partSplit[1]);
                }
                if (!partSplit[0].startsWith("expires_in")) continue;
                expiresIn = Uri.decode((String)partSplit[1]);
            }
            builder.setAccessToken(accessToken);
            builder.setState(state);
            if (expiresIn != null) {
                try {
                    builder.setExpiresIn(Integer.parseInt(expiresIn));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            builder.setType(Type.TOKEN);
            return builder.build();
        }
        builder.setType(Type.UNKNOWN);
        return builder.build();
    }

    @NonNull
    public Type getType() {
        return this.mType;
    }

    @Nullable
    public String getCode() {
        return this.mCode;
    }

    @Nullable
    public String getAccessToken() {
        return this.mAccessToken;
    }

    @Nullable
    public String getState() {
        return this.mState;
    }

    @Nullable
    public String getError() {
        return this.mError;
    }

    public int getExpiresIn() {
        return this.mExpiresIn;
    }

    @Nullable
    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mExpiresIn);
        dest.writeString(this.mError);
        dest.writeString(this.mState);
        dest.writeString(this.mAccessToken);
        dest.writeString(this.mCode);
        dest.writeInt(this.mType.ordinal());
        dest.writeString(this.mRefreshToken);
    }

    public static class Builder {
        private Type mType;
        private String mCode;
        private String mAccessToken;
        private String mState;
        private String mError;
        private int mExpiresIn;
        @Nullable
        private String mRefreshToken;

        Builder setType(Type type) {
            this.mType = type;
            return this;
        }

        Builder setCode(String code) {
            this.mCode = code;
            return this;
        }

        Builder setAccessToken(String accessToken) {
            this.mAccessToken = accessToken;
            return this;
        }

        Builder setState(String state) {
            this.mState = state;
            return this;
        }

        Builder setError(String error) {
            this.mError = error;
            return this;
        }

        Builder setExpiresIn(int expiresIn) {
            this.mExpiresIn = expiresIn;
            return this;
        }

        Builder setRefreshToken(@Nullable String refreshToken) {
            this.mRefreshToken = refreshToken;
            return this;
        }

        AuthorizationResponse build() {
            return new AuthorizationResponse(this.mType, this.mCode, this.mAccessToken, this.mState, this.mError, this.mExpiresIn, this.mRefreshToken);
        }
    }

    public static enum Type {
        CODE("code"),
        TOKEN("token"),
        ERROR("error"),
        EMPTY("empty"),
        UNKNOWN("unknown");

        private final String mType;

        private Type(String type) {
            this.mType = type;
        }

        public String toString() {
            return this.mType;
        }
    }
}

