/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.spotify.sdk.android.auth.AuthorizationRequest;
import com.spotify.sdk.android.auth.app.Sha1HashUtil;
import com.spotify.sdk.android.auth.app.Sha1HashUtilImpl;

public class SpotifyNativeAuthUtil {
    private static final int PROTOCOL_VERSION = 1;
    private static final String SPOTIFY_AUTH_ACTIVITY_ACTION = "com.spotify.sso.action.START_AUTH_FLOW";
    private static final String SPOTIFY_PACKAGE_NAME = "com.spotify.music";
    private static final String[] SPOTIFY_PACKAGE_SUFFIXES = new String[]{".debug", ".canary", ".partners", ""};
    private static final String[] SPOTIFY_SIGNATURE_HASH = new String[]{"25a9b2d2745c098361edaa3b87936dc29a28e7f1", "80abdd17dcc4cb3a33815d354355bf87c9378624", "88df4d670ed5e01fc7b3eff13b63258628ff5a00", "d834ae340d1e854c5f4092722f9788216d9221e5", "1cbedd9e7345f64649bad2b493a20d9eea955352", "4b3d76a2de89033ea830f476a1f815692938e33b"};
    private final Activity mContextActivity;
    private final AuthorizationRequest mRequest;
    @NonNull
    private final Sha1HashUtil mSha1HashUtil;

    public SpotifyNativeAuthUtil(Activity contextActivity, AuthorizationRequest request, @NonNull Sha1HashUtil sha1HashUtil) {
        this.mContextActivity = contextActivity;
        this.mRequest = request;
        this.mSha1HashUtil = sha1HashUtil;
    }

    public boolean startAuthActivity() {
        Intent intent = SpotifyNativeAuthUtil.createAuthActivityIntent((Context)this.mContextActivity, this.mSha1HashUtil);
        if (intent == null) {
            return false;
        }
        intent.putExtra("VERSION", 1);
        intent.putExtra("CLIENT_ID", this.mRequest.getClientId());
        intent.putExtra("REDIRECT_URI", this.mRequest.getRedirectUri());
        intent.putExtra("RESPONSE_TYPE", this.mRequest.getResponseType());
        intent.putExtra("SCOPES", this.mRequest.getScopes());
        intent.putExtra("STATE", this.mRequest.getState());
        try {
            this.mContextActivity.startActivityForResult(intent, 1138);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Intent createAuthActivityIntent(@NonNull Context context) {
        return SpotifyNativeAuthUtil.createAuthActivityIntent(context, new Sha1HashUtilImpl());
    }

    @VisibleForTesting
    static Intent createAuthActivityIntent(@NonNull Context context, @NonNull Sha1HashUtil sha1HashUtil) {
        Intent intent = null;
        for (String suffix : SPOTIFY_PACKAGE_SUFFIXES) {
            intent = SpotifyNativeAuthUtil.tryResolveActivity(context, SPOTIFY_PACKAGE_NAME + suffix, sha1HashUtil);
            if (intent != null) break;
        }
        return intent;
    }

    public static boolean isSpotifyInstalled(@NonNull Context context) {
        return SpotifyNativeAuthUtil.isSpotifyInstalled(context, new Sha1HashUtilImpl());
    }

    @VisibleForTesting
    static boolean isSpotifyInstalled(@NonNull Context context, @NonNull Sha1HashUtil sha1HashUtil) {
        return SpotifyNativeAuthUtil.createAuthActivityIntent(context, sha1HashUtil) != null;
    }

    @Nullable
    private static Intent tryResolveActivity(@NonNull Context context, @NonNull String packageName, @NonNull Sha1HashUtil sha1HashUtil) {
        Intent intent = new Intent(SPOTIFY_AUTH_ACTIVITY_ACTION);
        intent.setPackage(packageName);
        ComponentName componentName = intent.resolveActivity(context.getPackageManager());
        if (componentName == null) {
            return null;
        }
        if (!SpotifyNativeAuthUtil.validateSignature(context, componentName.getPackageName(), sha1HashUtil)) {
            return null;
        }
        return intent;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private static boolean validateSignature(@NonNull Context context, String spotifyPackageName, @NonNull Sha1HashUtil sha1HashUtil) {
        try {
            if (Build.VERSION.SDK_INT >= 28) {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(spotifyPackageName, 0x8000000);
                if (packageInfo.signingInfo == null) {
                    return false;
                }
                if (packageInfo.signingInfo.hasMultipleSigners()) {
                    return SpotifyNativeAuthUtil.validateSignatures(sha1HashUtil, packageInfo.signingInfo.getApkContentsSigners());
                }
                return SpotifyNativeAuthUtil.validateSignatures(sha1HashUtil, packageInfo.signingInfo.getSigningCertificateHistory());
            }
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(spotifyPackageName, 64);
            return SpotifyNativeAuthUtil.validateSignatures(sha1HashUtil, packageInfo.signatures);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private static boolean validateSignatures(@NonNull Sha1HashUtil sha1HashUtil, @Nullable Signature[] apkSignatures) {
        if (apkSignatures == null || apkSignatures.length == 0) {
            return false;
        }
        for (Signature actualApkSignature : apkSignatures) {
            String signatureString = actualApkSignature.toCharsString();
            String sha1Signature = sha1HashUtil.sha1Hash(signatureString);
            boolean matchesSignature = false;
            for (String knownSpotifyHash : SPOTIFY_SIGNATURE_HASH) {
                if (!knownSpotifyHash.equalsIgnoreCase(sha1Signature)) continue;
                matchesSignature = true;
                break;
            }
            if (matchesSignature) continue;
            return false;
        }
        return true;
    }

    public void stopAuthActivity() {
        this.mContextActivity.finishActivity(1138);
    }
}

