package com.spotify.sdk.android.auth.browser;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.Nullable;

import com.spotify.sdk.android.auth.LoginActivity;

/**
 * Activity that receives the auth response sent by the browser's Custom Tab via deeplink.
 * The sole purpose of this activity is to forward the response back to {@link LoginActivity}.
 * This activity is used only during browser based auth flow - when the Spotify app is not
 * installed on the device.
 */
public class RedirectUriReceiverActivity extends Activity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = new Intent(this, LoginActivity.class);
        intent.setData(getIntent().getData());
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
        startActivity(intent);
        finish();
    }
}
