/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import com.spotify.sdk.android.auth.AuthorizationRequest;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SpotifyNativeAuthUtil {
    private static final int PROTOCOL_VERSION = 1;
    private static final String SPOTIFY_AUTH_ACTIVITY_ACTION = "com.spotify.sso.action.START_AUTH_FLOW";
    private static final String SPOTIFY_PACKAGE_NAME = "com.spotify.music";
    private static final String[] SPOTIFY_PACKAGE_SUFFIXES = new String[]{".debug", ".canary", ".partners", ""};
    private static final String[] SPOTIFY_SIGNATURE_HASH = new String[]{"25a9b2d2745c098361edaa3b87936dc29a28e7f1", "80abdd17dcc4cb3a33815d354355bf87c9378624", "88df4d670ed5e01fc7b3eff13b63258628ff5a00", "d834ae340d1e854c5f4092722f9788216d9221e5", "1cbedd9e7345f64649bad2b493a20d9eea955352", "4b3d76a2de89033ea830f476a1f815692938e33b"};
    private Activity mContextActivity;
    private AuthorizationRequest mRequest;
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    public SpotifyNativeAuthUtil(Activity contextActivity, AuthorizationRequest request) {
        this.mContextActivity = contextActivity;
        this.mRequest = request;
    }

    public boolean startAuthActivity() {
        Intent intent = this.createAuthActivityIntent();
        if (intent == null) {
            return false;
        }
        intent.putExtra("VERSION", 1);
        intent.putExtra("CLIENT_ID", this.mRequest.getClientId());
        intent.putExtra("REDIRECT_URI", this.mRequest.getRedirectUri());
        intent.putExtra("RESPONSE_TYPE", this.mRequest.getResponseType());
        intent.putExtra("SCOPES", this.mRequest.getScopes());
        intent.putExtra("STATE", this.mRequest.getState());
        try {
            this.mContextActivity.startActivityForResult(intent, 1138);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    private Intent createAuthActivityIntent() {
        Intent intent = null;
        for (String suffix : SPOTIFY_PACKAGE_SUFFIXES) {
            intent = this.tryResolveActivity(SPOTIFY_PACKAGE_NAME + suffix);
            if (intent != null) break;
        }
        return intent;
    }

    private Intent tryResolveActivity(String packageName) {
        Intent intent = new Intent(SPOTIFY_AUTH_ACTIVITY_ACTION);
        intent.setPackage(packageName);
        ComponentName componentName = intent.resolveActivity(this.mContextActivity.getPackageManager());
        if (componentName == null) {
            return null;
        }
        if (!this.validateSignature(componentName.getPackageName())) {
            return null;
        }
        return intent;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private boolean validateSignature(String spotifyPackageName) {
        try {
            PackageInfo packageInfo = this.mContextActivity.getPackageManager().getPackageInfo(spotifyPackageName, 64);
            if (packageInfo.signatures == null) {
                return false;
            }
            for (Signature actualApkSignature : packageInfo.signatures) {
                String signatureString = actualApkSignature.toCharsString();
                String sha1Signature = SpotifyNativeAuthUtil.sha1Hash(signatureString);
                for (String knownSpotifyHash : SPOTIFY_SIGNATURE_HASH) {
                    if (!knownSpotifyHash.equals(sha1Signature)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public void stopAuthActivity() {
        this.mContextActivity.finishActivity(1138);
    }

    private static String sha1Hash(String toHash) {
        String hash = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = toHash.getBytes("UTF-8");
            digest.update(bytes, 0, bytes.length);
            bytes = digest.digest();
            hash = SpotifyNativeAuthUtil.bytesToHex(bytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return hash;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

