/*
 * Decompiled with CFR 0.152.
 */
package com.tokenautocomplete;

import android.content.Context;
import android.widget.ArrayAdapter;
import android.widget.Filter;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class FilteredArrayAdapter<T>
extends ArrayAdapter<T> {
    private List<T> originalObjects;
    private Filter filter;

    public FilteredArrayAdapter(Context context, int resource, T[] objects) {
        this(context, resource, 0, objects);
    }

    public FilteredArrayAdapter(Context context, int resource, int textViewResourceId, T[] objects) {
        this(context, resource, textViewResourceId, new ArrayList<T>(Arrays.asList(objects)));
    }

    public FilteredArrayAdapter(Context context, int resource, List<T> objects) {
        this(context, resource, 0, objects);
    }

    public FilteredArrayAdapter(Context context, int resource, int textViewResourceId, List<T> objects) {
        super(context, resource, textViewResourceId, new ArrayList<T>(objects));
        this.originalObjects = objects;
    }

    @NonNull
    public Filter getFilter() {
        if (this.filter == null) {
            this.filter = new AppFilter();
        }
        return this.filter;
    }

    protected abstract boolean keepObject(T var1, String var2);

    private class AppFilter
    extends Filter {
        private AppFilter() {
        }

        protected Filter.FilterResults performFiltering(CharSequence chars) {
            ArrayList sourceObjects = new ArrayList(FilteredArrayAdapter.this.originalObjects);
            Filter.FilterResults result = new Filter.FilterResults();
            if (chars != null && chars.length() > 0) {
                String mask = chars.toString();
                ArrayList keptObjects = new ArrayList();
                for (Object object : sourceObjects) {
                    if (!FilteredArrayAdapter.this.keepObject(object, mask)) continue;
                    keptObjects.add(object);
                }
                result.count = keptObjects.size();
                result.values = keptObjects;
            } else {
                result.values = sourceObjects;
                result.count = sourceObjects.size();
            }
            return result;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            FilteredArrayAdapter.this.clear();
            if (results.count > 0) {
                FilteredArrayAdapter.this.addAll((Collection)results.values);
                FilteredArrayAdapter.this.notifyDataSetChanged();
            } else {
                FilteredArrayAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

