/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.interopoptimizer.standard.internal.strategy;

import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import com.speedment.jpastreamer.interopoptimizer.IntermediateOperationOptimizer;
import com.speedment.jpastreamer.pipeline.Pipeline;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationType;
import java.util.LinkedList;

public class MoveAnonymousLambdaOperations
implements IntermediateOperationOptimizer {
    public <T> Pipeline<T> optimize(Pipeline<T> pipeline) {
        IntermediateOperation intermediateOperation;
        LinkedList intermediateOperations = pipeline.intermediateOperations();
        LinkedList<IntermediateOperation> optimizedOperations = new LinkedList<IntermediateOperation>();
        for (int i = 0; i < intermediateOperations.size(); ++i) {
            IntermediateOperation currentOperation;
            intermediateOperation = (IntermediateOperation)intermediateOperations.get(i);
            if (i == 0 || !this.movable(intermediateOperation)) {
                optimizedOperations.add(intermediateOperation);
                continue;
            }
            int position = optimizedOperations.size();
            int j = optimizedOperations.size() - 1;
            while (j >= 0 && this.shouldSwap(intermediateOperation, currentOperation = (IntermediateOperation)optimizedOperations.get(j))) {
                position = j--;
            }
            if (position < optimizedOperations.size()) {
                optimizedOperations.add(position, intermediateOperation);
                continue;
            }
            optimizedOperations.add(intermediateOperation);
        }
        for (int k = 0; k < intermediateOperations.size(); ++k) {
            intermediateOperation = (IntermediateOperation)optimizedOperations.get(k);
            intermediateOperations.set(k, intermediateOperation);
        }
        return pipeline;
    }

    private boolean movable(IntermediateOperation<?, ?> operation) {
        IntermediateOperationType type = (IntermediateOperationType)operation.type();
        return (type == IntermediateOperationType.FILTER || type == IntermediateOperationType.SORTED || type == IntermediateOperationType.DISTINCT) && this.jpaStreamerOperator(operation);
    }

    private boolean shouldSwap(IntermediateOperation<?, ?> operation, IntermediateOperation<?, ?> nextOperation) {
        IntermediateOperationType type = (IntermediateOperationType)operation.type();
        IntermediateOperationType nextType = (IntermediateOperationType)nextOperation.type();
        boolean jpaStreamerOperation = this.jpaStreamerOperator(nextOperation);
        switch (type) {
            case FILTER: {
                if (nextType == IntermediateOperationType.SORTED || nextType == IntermediateOperationType.DISTINCT) {
                    return true;
                }
                if (nextType == IntermediateOperationType.FILTER) {
                    return !jpaStreamerOperation;
                }
                return false;
            }
            case SORTED: {
                return (nextType == IntermediateOperationType.FILTER || nextType == IntermediateOperationType.DISTINCT) && !jpaStreamerOperation;
            }
            case DISTINCT: {
                return (nextType == IntermediateOperationType.FILTER || nextType == IntermediateOperationType.SORTED) && !jpaStreamerOperation;
            }
        }
        return false;
    }

    private boolean jpaStreamerOperator(IntermediateOperation<?, ?> operation) {
        if (operation.type() == IntermediateOperationType.DISTINCT) {
            return true;
        }
        Object[] arguments = operation.arguments();
        return arguments != null && (arguments[0] instanceof SpeedmentPredicate || arguments[0] instanceof Field);
    }
}

