/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal.predicate.ints;

import com.speedment.jpastreamer.field.internal.predicate.AbstractFieldPredicate;
import com.speedment.jpastreamer.field.internal.predicate.ints.IntBetweenPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.PredicateType;
import com.speedment.jpastreamer.field.predicate.trait.HasInclusion;
import com.speedment.jpastreamer.field.trait.HasArg0;
import com.speedment.jpastreamer.field.trait.HasArg1;
import com.speedment.jpastreamer.field.trait.HasIntValue;
import java.util.Objects;

public final class IntNotBetweenPredicate<ENTITY>
extends AbstractFieldPredicate<ENTITY, HasIntValue<ENTITY>>
implements HasInclusion,
HasArg0<Integer>,
HasArg1<Integer> {
    private final int start;
    private final int end;
    private final Inclusion inclusion;

    public IntNotBetweenPredicate(HasIntValue<ENTITY> field, int start, int end, Inclusion inclusion) {
        super(PredicateType.NOT_BETWEEN, field, entity -> {
            int fieldValue = field.getAsInt(entity);
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return start >= fieldValue || end <= fieldValue;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return start >= fieldValue || end < fieldValue;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return start > fieldValue || end <= fieldValue;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return start > fieldValue || end < fieldValue;
                }
            }
            throw new IllegalStateException("Inclusion unknown: " + String.valueOf((Object)inclusion));
        });
        this.start = start;
        this.end = end;
        this.inclusion = Objects.requireNonNull(inclusion);
    }

    @Override
    public Integer get0() {
        return this.start;
    }

    @Override
    public Integer get1() {
        return this.end;
    }

    @Override
    public Inclusion getInclusion() {
        return this.inclusion;
    }

    @Override
    public IntBetweenPredicate<ENTITY> negate() {
        return new IntBetweenPredicate((HasIntValue)this.getField(), this.start, this.end, this.inclusion);
    }
}

