/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal;

import com.speedment.jpastreamer.field.EnumField;
import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.field.comparator.FieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.ReferenceFieldComparatorImpl;
import com.speedment.jpastreamer.field.internal.predicate.AlwaysFalsePredicate;
import com.speedment.jpastreamer.field.internal.predicate.enums.EnumIsNotNullPredicate;
import com.speedment.jpastreamer.field.internal.predicate.enums.EnumIsNullPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceInPredicate;
import com.speedment.jpastreamer.field.method.ReferenceGetter;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Predicate;

public final class EnumFieldImpl<ENTITY, E extends Enum<E>>
implements EnumField<ENTITY, E>,
FieldComparator<ENTITY> {
    private final Class<ENTITY> table;
    private final String columnName;
    private final ReferenceGetter<ENTITY, E> getter;
    private final Class<E> enumClass;
    private final EnumSet<E> constants;

    public EnumFieldImpl(Class<ENTITY> table, String columnName, ReferenceGetter<ENTITY, E> getter, Class<E> enumClass) {
        this.table = Objects.requireNonNull(table);
        this.columnName = Objects.requireNonNull(columnName);
        this.getter = Objects.requireNonNull(getter);
        this.enumClass = Objects.requireNonNull(enumClass);
        this.constants = EnumSet.allOf(enumClass);
    }

    @Override
    public Class<E> enumClass() {
        return this.enumClass;
    }

    @Override
    public EnumSet<E> constants() {
        return EnumSet.allOf(this.enumClass);
    }

    @Override
    public Class<ENTITY> table() {
        return this.table;
    }

    @Override
    public ReferenceGetter<ENTITY, E> getter() {
        return this.getter;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public FieldComparator<ENTITY> comparator() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.LAST);
    }

    @Override
    public FieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.FIRST);
    }

    @Override
    public Field<ENTITY> getField() {
        return this;
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public int compare(ENTITY first, ENTITY second) {
        Enum f = (Enum)this.get(first);
        Enum s = (Enum)this.get(second);
        if (f == null && s == null) {
            return 0;
        }
        if (f == null) {
            return 1;
        }
        if (s == null) {
            return -1;
        }
        return f.compareTo(s);
    }

    @Override
    public EnumIsNullPredicate<ENTITY, E> isNull() {
        return new EnumIsNullPredicate(this);
    }

    @Override
    public EnumIsNotNullPredicate<ENTITY, E> isNotNull() {
        return new EnumIsNotNullPredicate(this);
    }

    @Override
    public SpeedmentPredicate<ENTITY> equal(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) == 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) != 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) < 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) <= 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterThan(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) > 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterOrEqual(E value) {
        return this.toEntityPredicate(e -> e != null && e.compareTo(value) >= 0);
    }

    @Override
    public SpeedmentPredicate<ENTITY> between(E start, E end, Inclusion inclusion) {
        return this.toEntityPredicate(e -> {
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return e.compareTo(start) > 0 && e.compareTo(end) < 0;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return e.compareTo(start) > 0 && e.compareTo(end) <= 0;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return e.compareTo(start) >= 0 && e.compareTo(end) < 0;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return e.compareTo(start) >= 0 && e.compareTo(end) <= 0;
                }
            }
            throw this.newUnsupportedOperationException(inclusion);
        });
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(E start, E end, Inclusion inclusion) {
        return this.toEntityPredicate(e -> {
            switch (inclusion) {
                case START_EXCLUSIVE_END_EXCLUSIVE: {
                    return e.compareTo(start) <= 0 || e.compareTo(end) >= 0;
                }
                case START_EXCLUSIVE_END_INCLUSIVE: {
                    return e.compareTo(start) <= 0 || e.compareTo(end) > 0;
                }
                case START_INCLUSIVE_END_EXCLUSIVE: {
                    return e.compareTo(start) < 0 || e.compareTo(end) >= 0;
                }
                case START_INCLUSIVE_END_INCLUSIVE: {
                    return e.compareTo(start) < 0 || e.compareTo(end) > 0;
                }
            }
            throw this.newUnsupportedOperationException(inclusion);
        });
    }

    private UnsupportedOperationException newUnsupportedOperationException(Inclusion inclusion) {
        return new UnsupportedOperationException("Unknown inclusion '" + String.valueOf((Object)inclusion) + "'.");
    }

    @Override
    public SpeedmentPredicate<ENTITY> in(Collection<E> values) {
        return this.toEntityPredicate(values::contains);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<E> values) {
        return this.toEntityPredicate(e -> !values.contains(e));
    }

    private SpeedmentPredicate<ENTITY> toEntityPredicate(Predicate<E> predicate) {
        EnumSet<E> valid = this.evaluate(predicate);
        switch (valid.size()) {
            case 0: {
                return new AlwaysFalsePredicate(this);
            }
            case 1: {
                return new ReferenceEqualPredicate(this, (Enum)valid.iterator().next());
            }
        }
        return new ReferenceInPredicate(this, valid);
    }

    private EnumSet<E> evaluate(Predicate<E> predicate) {
        EnumSet<E> result = EnumSet.noneOf(this.enumClass);
        this.constants.stream().filter(predicate).forEach(result::add);
        return result;
    }

    @Override
    public String columnName() {
        return this.columnName;
    }
}

