/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal;

import com.speedment.jpastreamer.field.ByteField;
import com.speedment.jpastreamer.field.comparator.ByteFieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.ByteFieldComparatorImpl;
import com.speedment.jpastreamer.field.internal.method.GetByteImpl;
import com.speedment.jpastreamer.field.internal.predicate.bytes.ByteBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.bytes.ByteEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.bytes.ByteGreaterOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.bytes.ByteGreaterThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.bytes.ByteInPredicate;
import com.speedment.jpastreamer.field.internal.predicate.bytes.ByteLessOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.bytes.ByteLessThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.bytes.ByteNotBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.bytes.ByteNotEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.bytes.ByteNotInPredicate;
import com.speedment.jpastreamer.field.internal.util.CollectionUtil;
import com.speedment.jpastreamer.field.method.ByteGetter;
import com.speedment.jpastreamer.field.method.GetByte;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import java.util.Collection;
import java.util.Objects;

public final class ByteFieldImpl<ENTITY>
implements ByteField<ENTITY> {
    private final Class<ENTITY> table;
    private final String columnName;
    private final GetByte<ENTITY> getter;
    private final boolean unique;

    public ByteFieldImpl(Class<ENTITY> table, String columnName, ByteGetter<ENTITY> getter, boolean unique) {
        this.table = Objects.requireNonNull(table);
        this.columnName = Objects.requireNonNull(columnName);
        this.getter = new GetByteImpl(this, getter);
        this.unique = unique;
    }

    @Override
    public Class<ENTITY> table() {
        return this.table;
    }

    @Override
    public GetByte<ENTITY> getter() {
        return this.getter;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public ByteFieldComparator<ENTITY> comparator() {
        return new ByteFieldComparatorImpl(this);
    }

    @Override
    public ByteFieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public ByteFieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(Byte value) {
        return new ByteEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Byte value) {
        return new ByteGreaterThanPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Byte value) {
        return new ByteGreaterOrEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> between(Byte start, Byte end, Inclusion inclusion) {
        return new ByteBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Byte> values) {
        return new ByteInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(Byte value) {
        return new ByteNotEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(Byte value) {
        return new ByteLessOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(Byte value) {
        return new ByteLessThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(Byte start, Byte end, Inclusion inclusion) {
        return new ByteNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<Byte> values) {
        return new ByteNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public String columnName() {
        return this.columnName;
    }
}

