/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal.comparator;

import com.speedment.common.invariant.NullUtil;
import com.speedment.jpastreamer.field.comparator.FieldComparator;
import com.speedment.jpastreamer.field.comparator.FloatFieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.AbstractFieldComparator;
import com.speedment.jpastreamer.field.trait.HasFloatValue;
import java.util.Objects;

public final class FloatFieldComparatorImpl<ENTITY>
extends AbstractFieldComparator<ENTITY>
implements FloatFieldComparator<ENTITY> {
    private final HasFloatValue<ENTITY> field;
    private final boolean reversed;

    public FloatFieldComparatorImpl(HasFloatValue<ENTITY> field) {
        this(field, false);
    }

    FloatFieldComparatorImpl(HasFloatValue<ENTITY> field, boolean reversed) {
        this.field = Objects.requireNonNull(field);
        this.reversed = reversed;
    }

    @Override
    public HasFloatValue<ENTITY> getField() {
        return this.field;
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.NONE;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public FloatFieldComparatorImpl<ENTITY> reversed() {
        return new FloatFieldComparatorImpl<ENTITY>(this.field, !this.reversed);
    }

    @Override
    public int compare(ENTITY first, ENTITY second) {
        NullUtil.requireNonNulls(first, second);
        float a = this.field.getAsFloat(first);
        float b = this.field.getAsFloat(second);
        return this.applyReversed(Float.compare(a, b));
    }

    public int hashCode() {
        return (4049 + Objects.hashCode(this.field.table())) * 3109 + Boolean.hashCode(this.reversed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldComparator)) {
            return false;
        }
        FieldComparator casted = (FieldComparator)obj;
        return this.reversed == casted.isReversed() && Objects.equals(this.field.table(), casted.getField().table());
    }

    public String toString() {
        return "(order by " + String.valueOf(this.field.table()) + " " + (this.reversed ? "descending" : "ascending") + ")";
    }

    private int applyReversed(float compare) {
        if (compare == 0.0f) {
            return 0;
        }
        if (this.reversed) {
            if (compare > 0.0f) {
                return -1;
            }
            return 1;
        }
        if (compare > 0.0f) {
            return 1;
        }
        return -1;
    }
}

