/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal;

import com.speedment.jpastreamer.field.ShortField;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.comparator.ShortFieldComparator;
import com.speedment.jpastreamer.field.internal.comparator.ShortFieldComparatorImpl;
import com.speedment.jpastreamer.field.internal.method.GetShortImpl;
import com.speedment.jpastreamer.field.internal.predicate.shorts.ShortBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.shorts.ShortEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.shorts.ShortGreaterOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.shorts.ShortGreaterThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.shorts.ShortInPredicate;
import com.speedment.jpastreamer.field.internal.predicate.shorts.ShortLessOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.shorts.ShortLessThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.shorts.ShortNotBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.shorts.ShortNotEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.shorts.ShortNotInPredicate;
import com.speedment.jpastreamer.field.internal.util.CollectionUtil;
import com.speedment.jpastreamer.field.method.GetShort;
import com.speedment.jpastreamer.field.method.ShortGetter;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import java.util.Collection;
import java.util.Objects;

public final class ShortFieldImpl<ENTITY>
implements ShortField<ENTITY> {
    private final Class<ENTITY> table;
    private final String columnName;
    private final GetShort<ENTITY> getter;
    private final boolean unique;

    public ShortFieldImpl(Class<ENTITY> table, String columnName, ShortGetter<ENTITY> getter, boolean unique) {
        this.table = Objects.requireNonNull(table);
        this.columnName = Objects.requireNonNull(columnName);
        this.getter = new GetShortImpl<ENTITY>(this, getter);
        this.unique = unique;
    }

    @Override
    public Class<ENTITY> table() {
        return this.table;
    }

    @Override
    public GetShort<ENTITY> getter() {
        return this.getter;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public ShortFieldComparator<ENTITY> comparator() {
        return new ShortFieldComparatorImpl(this);
    }

    @Override
    public ShortFieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public ShortFieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(Short value) {
        return new ShortEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Short value) {
        return new ShortGreaterThanPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Short value) {
        return new ShortGreaterOrEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> between(Short start, Short end, Inclusion inclusion) {
        return new ShortBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Short> values) {
        return new ShortInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(Short value) {
        return new ShortNotEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(Short value) {
        return new ShortLessOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(Short value) {
        return new ShortLessThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(Short start, Short end, Inclusion inclusion) {
        return new ShortNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<Short> values) {
        return new ShortNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public String columnName() {
        return this.columnName;
    }
}

