/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal;

import com.speedment.jpastreamer.field.IntField;
import com.speedment.jpastreamer.field.comparator.IntFieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.IntFieldComparatorImpl;
import com.speedment.jpastreamer.field.internal.method.GetIntImpl;
import com.speedment.jpastreamer.field.internal.predicate.ints.IntBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.ints.IntEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.ints.IntGreaterOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.ints.IntGreaterThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.ints.IntInPredicate;
import com.speedment.jpastreamer.field.internal.predicate.ints.IntLessOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.ints.IntLessThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.ints.IntNotBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.ints.IntNotEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.ints.IntNotInPredicate;
import com.speedment.jpastreamer.field.internal.util.CollectionUtil;
import com.speedment.jpastreamer.field.method.GetInt;
import com.speedment.jpastreamer.field.method.IntGetter;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import java.util.Collection;
import java.util.Objects;

public final class IntFieldImpl<ENTITY>
implements IntField<ENTITY> {
    private final Class<ENTITY> table;
    private final String columnName;
    private final GetInt<ENTITY> getter;
    private final boolean unique;

    public IntFieldImpl(Class<ENTITY> table, String columnName, IntGetter<ENTITY> getter, boolean unique) {
        this.table = Objects.requireNonNull(table);
        this.columnName = Objects.requireNonNull(columnName);
        this.getter = new GetIntImpl(this, getter);
        this.unique = unique;
    }

    @Override
    public Class<ENTITY> table() {
        return this.table;
    }

    @Override
    public GetInt<ENTITY> getter() {
        return this.getter;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public IntFieldComparator<ENTITY> comparator() {
        return new IntFieldComparatorImpl(this);
    }

    @Override
    public IntFieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public IntFieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(Integer value) {
        return new IntEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Integer value) {
        return new IntGreaterThanPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Integer value) {
        return new IntGreaterOrEqualPredicate(this, value);
    }

    @Override
    public FieldPredicate<ENTITY> between(Integer start, Integer end, Inclusion inclusion) {
        return new IntBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Integer> values) {
        return new IntInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(Integer value) {
        return new IntNotEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(Integer value) {
        return new IntLessOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(Integer value) {
        return new IntLessThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(Integer start, Integer end, Inclusion inclusion) {
        return new IntNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<Integer> values) {
        return new IntNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public String columnName() {
        return this.columnName;
    }
}

