/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.application;

import com.speedment.jpastreamer.application.JPAStreamerBuilder;
import com.speedment.jpastreamer.application.JPAStreamerBuilderFactory;
import com.speedment.jpastreamer.projection.Projection;
import com.speedment.jpastreamer.rootfactory.RootFactory;
import com.speedment.jpastreamer.streamconfiguration.StreamConfiguration;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

public interface JPAStreamer {
    public <T> Stream<T> stream(StreamConfiguration<T> var1);

    default public <T> Stream<T> stream(Class<T> entityClass) {
        Objects.requireNonNull(entityClass);
        return this.stream(StreamConfiguration.of(entityClass));
    }

    default public <T> Stream<T> stream(Projection<T> projection) {
        Objects.requireNonNull(projection);
        return this.stream(StreamConfiguration.of((Class)projection.entityClass()).selecting(projection));
    }

    public void resetStreamer(Class<?> ... var1) throws UnsupportedOperationException;

    public void close();

    public static JPAStreamerBuilder createJPAStreamerBuilder(String persistenceUnitName) {
        return ((JPAStreamerBuilderFactory)RootFactory.getOrThrow(JPAStreamerBuilderFactory.class, ServiceLoader::load)).create(persistenceUnitName);
    }

    public static JPAStreamerBuilder createJPAStreamerBuilder(EntityManagerFactory entityManagerFactory) {
        return ((JPAStreamerBuilderFactory)RootFactory.getOrThrow(JPAStreamerBuilderFactory.class, ServiceLoader::load)).create(entityManagerFactory);
    }

    public static JPAStreamerBuilder createJPAStreamerBuilder(Supplier<EntityManager> entityManagerSupplier) {
        return ((JPAStreamerBuilderFactory)RootFactory.getOrThrow(JPAStreamerBuilderFactory.class, ServiceLoader::load)).create(entityManagerSupplier);
    }

    public static JPAStreamer of(String persistenceUnitName) {
        Objects.requireNonNull(persistenceUnitName);
        return JPAStreamer.createJPAStreamerBuilder(persistenceUnitName).build();
    }

    public static JPAStreamer of(EntityManagerFactory entityManagerFactory) {
        Objects.requireNonNull(entityManagerFactory);
        return JPAStreamer.createJPAStreamerBuilder(entityManagerFactory).build();
    }

    public static JPAStreamer of(Supplier<EntityManager> entityManagerSupplier) {
        Objects.requireNonNull(entityManagerSupplier);
        return JPAStreamer.createJPAStreamerBuilder(entityManagerSupplier).build();
    }
}

