/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.analytics.standard.internal;

import com.speedment.jpastreamer.analytics.AnalyticsReporter;
import com.speedment.jpastreamer.analytics.standard.internal.Handler;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class InternalStandardAnalyticsReporter
implements AnalyticsReporter {
    private static final long ALIVE_INTERVAL_MS = TimeUnit.MINUTES.toMillis(20L);
    private static final AtomicInteger THREAD_COUNT = new AtomicInteger();
    private final ScheduledExecutorService executorService;
    private final AtomicBoolean started;
    private final AtomicBoolean stopped;
    private final Handler handler;

    public InternalStandardAnalyticsReporter(Handler handler) {
        this.handler = Objects.requireNonNull(handler);
        this.executorService = Executors.newScheduledThreadPool(1, this::threadFactory);
        this.started = new AtomicBoolean();
        this.stopped = new AtomicBoolean();
    }

    public void start() {
        if (!this.stopped.get() && this.started.compareAndSet(false, true)) {
            this.executorService.schedule(this.handler::starting, 1L, TimeUnit.MILLISECONDS);
            this.executorService.scheduleAtFixedRate(this.handler::running, ALIVE_INTERVAL_MS, ALIVE_INTERVAL_MS, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.started.get() && this.stopped.compareAndSet(false, true)) {
            this.executorService.execute(this.handler::stopping);
            try {
                Thread.sleep(10L);
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                    System.out.println("Warning: Unable to shutdown analytics reporter.");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executorService.shutdownNow();
        }
    }

    private Thread threadFactory(Runnable runnable) {
        Objects.requireNonNull(runnable);
        Thread thread = new Thread(runnable, InternalStandardAnalyticsReporter.class.getSimpleName() + "-" + THREAD_COUNT.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    }
}

