/*
 * Decompiled with CFR 0.152.
 */
package spark.template.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import spark.ModelAndView;
import spark.TemplateViewRoute;

public abstract class FreeMarkerRoute
extends TemplateViewRoute {
    private Configuration configuration = this.createDefaultConfiguration();

    protected FreeMarkerRoute(String path) {
        super(path);
    }

    protected FreeMarkerRoute(String path, String acceptType) {
        super(path, acceptType);
    }

    public String render(ModelAndView modelAndView) {
        try {
            StringWriter stringWriter = new StringWriter();
            Template template = this.configuration.getTemplate(modelAndView.getViewName());
            template.process(modelAndView.getModel(), (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (TemplateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private Configuration createDefaultConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setClassForTemplateLoading(FreeMarkerRoute.class, "");
        return configuration;
    }
}

