/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.klock.internal;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0005J\u0006\u0010\u0019\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003J\r\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0007\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/soywiz/klock/internal/MicroStrReader;", "", "str", "", "offset", "", "(Ljava/lang/String;I)V", "available", "getAvailable", "()I", "hasMore", "", "getHasMore", "()Z", "length", "getLength", "getOffset", "setOffset", "(I)V", "getStr", "()Ljava/lang/String;", "peekChar", "", "read", "count", "readChar", "readInt", "tryRead", "tryReadDouble", "", "()Ljava/lang/Double;", "(I)Ljava/lang/Double;", "tryReadInt", "(I)Ljava/lang/Integer;", "klock_debug"})
public final class MicroStrReader {
    @NotNull
    private final String str;
    private int offset;

    public final int getLength() {
        return this.str.length();
    }

    public final int getAvailable() {
        return this.str.length() - this.offset;
    }

    public final boolean getHasMore() {
        return this.offset < this.str.length();
    }

    public final char peekChar() {
        return this.str.charAt(this.offset);
    }

    public final char readChar() {
        int n = this.offset;
        this.offset = n + 1;
        return this.str.charAt(n);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryRead(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        if (str.length() > this.getAvailable()) {
            return false;
        }
        int n = 0;
        int n2 = str.length();
        while (n < n2) {
            void n3;
            if (this.str.charAt(this.offset + n3) != str.charAt((int)n3)) {
                return false;
            }
            ++n3;
        }
        this.offset += str.length();
        return true;
    }

    @NotNull
    public final String read(int count) {
        String string = this.str;
        int n = this.offset;
        int n2 = RangesKt.coerceAtMost((int)(this.offset + count), (int)this.getLength());
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string3;
        n = 0;
        n2 = 0;
        String it = string;
        boolean bl2 = false;
        this.offset += it.length();
        return string;
    }

    public final int readInt(int count) {
        String string = this.read(count);
        boolean bl = false;
        return Integer.parseInt(string);
    }

    @Nullable
    public final Integer tryReadInt(int count) {
        return StringsKt.toIntOrNull((String)this.read(count));
    }

    @Nullable
    public final Double tryReadDouble(int count) {
        return StringsKt.toDoubleOrNull((String)StringsKt.replace$default((String)this.read(count), (char)',', (char)'.', (boolean)false, (int)4, null));
    }

    @Nullable
    public final Double tryReadDouble() {
        int numCount = 0;
        int num = 0;
        int denCount = 0;
        int den = 0;
        boolean decimals = false;
        while (this.getHasMore()) {
            char pc = this.peekChar();
            if (pc == ',') {
                if (numCount == 0) {
                    return null;
                }
                decimals = true;
                this.readChar();
                continue;
            }
            char c = pc;
            if ('0' > c || '9' < c) break;
            char c2 = this.readChar();
            if (decimals) {
                ++denCount;
                den *= 10;
                den += c2 - 48;
                continue;
            }
            ++numCount;
            num *= 10;
            num += c2 - 48;
        }
        if (numCount == 0) {
            return null;
        }
        double d = 10.0;
        int n = -denCount;
        double d2 = den;
        double d3 = num;
        boolean bl = false;
        double d4 = Math.pow(d, n);
        return d3 + d2 * d4;
    }

    @NotNull
    public final String getStr() {
        return this.str;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public MicroStrReader(@NotNull String str, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        this.str = str;
        this.offset = offset;
    }

    public /* synthetic */ MicroStrReader(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(string, n);
    }
}

