/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import com.soywiz.kds.IntDeque;
import com.soywiz.kds._ExtensionsKt;
import com.soywiz.kds.internal.InternalKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0002J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0002J\b\u0010\u001f\u001a\u00020\u0019H\u0016J\u0011\u0010 \u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010!\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J(\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0002H\u0002J\u0013\u0010'\u001a\u00020\u00122\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\u0011\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0002H\u0086\u0002J\b\u0010,\u001a\u00020\u0002H\u0016J\u000e\u0010-\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002J\u0010\u0010.\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0002H\u0002J\b\u0010/\u001a\u00020\u0012H\u0016J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000201H\u0096\u0002J\u0015\u00102\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u00103J\u0016\u00104\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u000e\u00105\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0002J\u0006\u00106\u001a\u00020\u0002J\u0006\u00107\u001a\u00020\u0002J\u0010\u00108\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0002H\u0002J\u0016\u00109\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u0019\u0010:\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00022\u0006\u0010;\u001a\u00020\u0002H\u0086\u0002J\b\u0010<\u001a\u00020=H\u0016R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\u00a8\u0006>"}, d2={"Lcom/soywiz/kds/IntDeque;", "", "", "()V", "_size", "_start", "capacity", "getCapacity", "()I", "data", "", "first", "getFirst", "last", "getLast", "size", "getSize", "_removeRetainAll", "", "elements", "", "retain", "add", "element", "addAll", "", "items", "", "addFirst", "item", "addLast", "clear", "contains", "containsAll", "copyCyclic", "i", "istart", "o", "count", "equals", "other", "", "get", "index", "hashCode", "indexOf", "internalIndex", "isEmpty", "iterator", "", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "removeAt", "removeFirst", "removeLast", "resizeIfRequiredFor", "retainAll", "set", "value", "toString", "", "kds_debug"})
public class IntDeque
implements Collection<Integer>,
KMutableCollection {
    private int _start;
    private int _size;
    private int[] data = new int[16];

    private final int getCapacity() {
        return this.data.length;
    }

    public int getSize() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private final void resizeIfRequiredFor(int count) {
        if (this.size() + count > this.getCapacity()) {
            int[] i = this.data;
            int istart = this._start;
            int[] o = new int[this.data.length * 2];
            this.copyCyclic(i, istart, o, this._size);
            this.data = o;
            this._start = 0;
        }
    }

    private final void copyCyclic(int[] i, int istart, int[] o, int count) {
        int n = i.length - istart;
        boolean bl = false;
        int size1 = Math.min(n, count);
        int size2 = count - size1;
        InternalKt.arraycopy(i, istart, o, 0, size1);
        if (size2 > 0) {
            InternalKt.arraycopy(i, 0, o, size1, size2);
        }
    }

    public final void addAll(@NotNull Iterable<Integer> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        IntDeque intDeque = this;
        boolean bl = false;
        boolean bl2 = false;
        IntDeque $this$run = intDeque;
        boolean bl3 = false;
        $this$run.resizeIfRequiredFor(CollectionsKt.count(items));
        Iterator<Integer> iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            int i = ((Number)iterator2.next()).intValue();
            $this$run.addLast(i);
        }
    }

    public final void addFirst(int item) {
        this.resizeIfRequiredFor(1);
        this._start = InternalKt.umod(this._start - 1, this.getCapacity());
        int n = this._size;
        this._size = n + 1;
        this.data[this._start] = item;
    }

    public final void addLast(int item) {
        this.resizeIfRequiredFor(1);
        this.data[InternalKt.umod((int)(this._start + this.size()), (int)this.getCapacity())] = item;
        int n = this._size;
        this._size = n + 1;
    }

    public final int removeFirst() {
        if (this._size <= 0) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        int n = this.getFirst();
        boolean bl = false;
        boolean bl2 = false;
        int $this$apply = n;
        boolean bl3 = false;
        this._start = InternalKt.umod(this._start + 1, this.getCapacity());
        int n2 = this._size;
        this._size = n2 + -1;
        return n;
    }

    public final int removeLast() {
        if (this._size <= 0) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        int n = this.getLast();
        boolean bl = false;
        boolean bl2 = false;
        int $this$apply = n;
        boolean bl3 = false;
        int n2 = this._size;
        this._size = n2 + -1;
        return n;
    }

    public final int removeAt(int index) {
        int n;
        int n2;
        if (index < 0 || index >= this.size()) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        if (index == 0) {
            return this.removeFirst();
        }
        if (index == this.size() - 1) {
            return this.removeLast();
        }
        int old = this.get(index);
        if (index < this.size() / 2) {
            n2 = index;
            int n3 = 1;
            while (n2 >= n3) {
                this.set(n, this.get(n - 1));
                --n;
            }
            this._start = InternalKt.umod(this._start + 1, this.getCapacity());
        } else {
            int n4 = this.size() - 1;
            for (n = index; n < n4; ++n) {
                this.set(n, this.get(n + 1));
            }
        }
        n2 = this._size;
        this._size = n2 + -1;
        return old;
    }

    @Override
    public boolean add(int element) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean $this$apply = bl;
        boolean bl4 = false;
        this.addLast(element);
        return bl;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Integer> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean $this$apply = bl;
        boolean bl4 = false;
        this.addAll((Iterable<Integer>)elements);
        return bl;
    }

    @Override
    public void clear() {
        IntDeque intDeque = this;
        boolean bl = false;
        boolean bl2 = false;
        IntDeque $this$run = intDeque;
        boolean bl3 = false;
        $this$run._size = 0;
    }

    public boolean remove(@NotNull Integer element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index >= 0;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return this._removeRetainAll(elements, false);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return this._removeRetainAll(elements, true);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean _removeRetainAll(Collection<Integer> elements, boolean retain) {
        Set eset = CollectionsKt.toSet((Iterable)elements);
        int[] nArray = this.data;
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"java.util.Arrays.copyOf(this, size)");
        int[] temp = nArray2;
        int tsize = 0;
        int osize = this.size();
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            void n3;
            int c = this.get((int)n3);
            if (eset.contains(c) == retain) {
                temp[tsize++] = c;
            }
            ++n3;
        }
        this.data = temp;
        this._start = 0;
        this._size = tsize;
        return tsize != osize;
    }

    public final int getFirst() {
        return this.data[this._start];
    }

    public final int getLast() {
        return this.data[this.internalIndex(this.size() - 1)];
    }

    private final int internalIndex(int index) {
        return InternalKt.umod(this._start + index, this.getCapacity());
    }

    public final void set(int index, int value) {
        IntDeque intDeque = this;
        boolean bl = false;
        boolean bl2 = false;
        IntDeque $this$run = intDeque;
        boolean bl3 = false;
        $this$run.data[$this$run.internalIndex((int)index)] = value;
    }

    public final int get(int index) {
        return this.data[this.internalIndex(index)];
    }

    public boolean contains(int element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)this.size());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(this.get(it) == element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(int element) {
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            void n3;
            if (this.get((int)n3) == element) {
                return (int)n3;
            }
            ++n3;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block6: {
            int n;
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Iterable $this$map$iv22 = elements;
            int $i$f$map = 0;
            Iterable iterable = $this$map$iv22;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)((int)it), (Object)0);
                collection.add(pair);
            }
            LinkedHashMap emap = _ExtensionsKt.toLinkedMap((List)destination$iv$iv);
            int $this$map$iv22 = 0;
            $i$f$map = this.size();
            while ($this$map$iv22 < $i$f$map) {
                void it;
                int e = this.get((int)it);
                destination$iv$iv = emap;
                Integer $i$f$mapTo2 = e;
                boolean bl3 = false;
                Object object = destination$iv$iv;
                n = 0;
                if (object.containsKey($i$f$mapTo2)) {
                    ((Map)emap).put(e, 1);
                }
                ++it;
            }
            Collection collection = emap.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"emap.values");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Integer it = (Integer)element$iv;
                    boolean bl4 = false;
                    Integer n2 = it;
                    if (n2 != null && n2 == 1) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        IntDeque that = this;
        return new Iterator<Integer>(this, that){
            private int index;
            final /* synthetic */ IntDeque this$0;
            final /* synthetic */ IntDeque $that;

            public final int getIndex() {
                return this.index;
            }

            public final void setIndex(int n) {
                this.index = n;
            }

            @NotNull
            public Integer next() {
                int n = this.index;
                this.index = n + 1;
                return this.$that.get(n);
            }

            public boolean hasNext() {
                return this.index < this.this$0.size();
            }

            public void remove() {
                iterator.1 var1_1 = this;
                boolean bl = false;
                boolean bl2 = false;
                iterator.1 $this$run = var1_1;
                boolean bl3 = false;
                iterator.1 v0 = $this$run;
                v0.index += -1;
                this.this$0.removeAt(v0.index);
            }
            {
                this.this$0 = $outer;
                this.$that = $captured_local_variable$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var3_3;
        int size$iv = this.size();
        boolean $i$f$contentHashCode = false;
        int result$iv = 1;
        int n = 0;
        int n2 = size$iv;
        while (n < n2) {
            void it;
            Integer n3;
            void n$iv;
            void var6_7 = n$iv++;
            int n4 = 31 * result$iv;
            boolean bl = false;
            Integer n5 = n3 = Integer.valueOf(this.get((int)it));
            int n6 = n4;
            boolean bl2 = false;
            int n7 = ((Object)n5).hashCode();
            result$iv = n6 + n7;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof IntDeque)) {
            return false;
        }
        if (((IntDeque)other).size() != this.size()) {
            return false;
        }
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            void n3;
            if (this.get((int)n3) != ((IntDeque)other).get((int)n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            void n3;
            sb.append(this.get((int)n3));
            if (n3 != this.size() - 1) {
                sb.append(", ");
            }
            ++n3;
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }
}

