/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import com.soywiz.kds.DoubleDeque;
import com.soywiz.kds._ExtensionsKt;
import com.soywiz.kds.internal.InternalKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0016\u0010\u001a\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0002J\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0002J\b\u0010!\u001a\u00020\u001bH\u0016J\u0011\u0010\"\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010#\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J(\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0013\u0010)\u001a\u00020\u00142\b\u0010*\u001a\u0004\u0018\u00010+H\u0096\u0002J\u0011\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u0005H\u0086\u0002J\b\u0010.\u001a\u00020\u0005H\u0016J\u000e\u0010/\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0002J\u0010\u00100\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005H\u0002J\b\u00101\u001a\u00020\u0014H\u0016J\u000f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000203H\u0096\u0002J\u0010\u00104\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0016\u00105\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u000e\u00106\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u0005J\u0006\u00107\u001a\u00020\u0002J\u0006\u00108\u001a\u00020\u0002J\u0010\u00109\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0016\u0010:\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u0019\u0010;\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u0002H\u0086\u0002J\b\u0010=\u001a\u00020>H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\t\u00a8\u0006?"}, d2={"Lcom/soywiz/kds/DoubleDeque;", "", "", "()V", "_size", "", "_start", "capacity", "getCapacity", "()I", "data", "", "first", "getFirst", "()D", "last", "getLast", "size", "getSize", "_removeRetainAll", "", "elements", "", "retain", "add", "element", "addAll", "", "items", "", "addFirst", "item", "addLast", "clear", "contains", "containsAll", "copyCyclic", "i", "istart", "o", "count", "equals", "other", "", "get", "index", "hashCode", "indexOf", "internalIndex", "isEmpty", "iterator", "", "remove", "removeAll", "removeAt", "removeFirst", "removeLast", "resizeIfRequiredFor", "retainAll", "set", "value", "toString", "", "kds_debug"})
public class DoubleDeque
implements Collection<Double>,
KMutableCollection {
    private int _start;
    private int _size;
    private double[] data = new double[16];

    private final int getCapacity() {
        return this.data.length;
    }

    public int getSize() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private final void resizeIfRequiredFor(int count) {
        if (this.size() + count > this.getCapacity()) {
            double[] i = this.data;
            int istart = this._start;
            double[] o = new double[this.data.length * 2];
            this.copyCyclic(i, istart, o, this._size);
            this.data = o;
            this._start = 0;
        }
    }

    private final void copyCyclic(double[] i, int istart, double[] o, int count) {
        int n = i.length - istart;
        boolean bl = false;
        int size1 = Math.min(n, count);
        int size2 = count - size1;
        InternalKt.arraycopy(i, istart, o, 0, size1);
        if (size2 > 0) {
            InternalKt.arraycopy(i, 0, o, size1, size2);
        }
    }

    public final void addAll(@NotNull Iterable<Double> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        DoubleDeque doubleDeque = this;
        boolean bl = false;
        boolean bl2 = false;
        DoubleDeque $this$run = doubleDeque;
        boolean bl3 = false;
        $this$run.resizeIfRequiredFor(CollectionsKt.count(items));
        Iterator<Double> iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            double i = ((Number)iterator2.next()).doubleValue();
            $this$run.addLast(i);
        }
    }

    public final void addFirst(double item) {
        this.resizeIfRequiredFor(1);
        this._start = InternalKt.umod(this._start - 1, this.getCapacity());
        int n = this._size;
        this._size = n + 1;
        this.data[this._start] = item;
    }

    public final void addLast(double item) {
        this.resizeIfRequiredFor(1);
        this.data[InternalKt.umod((int)(this._start + this.size()), (int)this.getCapacity())] = item;
        int n = this._size;
        this._size = n + 1;
    }

    public final double removeFirst() {
        if (this._size <= 0) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        double d = this.getFirst();
        boolean bl = false;
        boolean bl2 = false;
        double $this$apply = d;
        boolean bl3 = false;
        this._start = InternalKt.umod(this._start + 1, this.getCapacity());
        int n = this._size;
        this._size = n + -1;
        return d;
    }

    public final double removeLast() {
        if (this._size <= 0) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        double d = this.getLast();
        boolean bl = false;
        boolean bl2 = false;
        double $this$apply = d;
        boolean bl3 = false;
        int n = this._size;
        this._size = n + -1;
        return d;
    }

    public final double removeAt(int index) {
        int n;
        int n2;
        if (index < 0 || index >= this.size()) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        if (index == 0) {
            return this.removeFirst();
        }
        if (index == this.size() - 1) {
            return this.removeLast();
        }
        double old = this.get(index);
        if (index < this.size() / 2) {
            n2 = index;
            int n3 = 1;
            while (n2 >= n3) {
                this.set(n, this.get(n - 1));
                --n;
            }
            this._start = InternalKt.umod(this._start + 1, this.getCapacity());
        } else {
            int n4 = this.size() - 1;
            for (n = index; n < n4; ++n) {
                this.set(n, this.get(n + 1));
            }
        }
        n2 = this._size;
        this._size = n2 + -1;
        return old;
    }

    @Override
    public boolean add(double element) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean $this$apply = bl;
        boolean bl4 = false;
        this.addLast(element);
        return bl;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Double> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean $this$apply = bl;
        boolean bl4 = false;
        this.addAll((Iterable<Double>)elements);
        return bl;
    }

    @Override
    public void clear() {
        DoubleDeque doubleDeque = this;
        boolean bl = false;
        boolean bl2 = false;
        DoubleDeque $this$run = doubleDeque;
        boolean bl3 = false;
        $this$run._size = 0;
    }

    public boolean remove(double element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index >= 0;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return this._removeRetainAll(elements, false);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return this._removeRetainAll(elements, true);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean _removeRetainAll(Collection<Double> elements, boolean retain) {
        Set eset = CollectionsKt.toSet((Iterable)elements);
        double[] dArray = this.data;
        boolean bl = false;
        double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)dArray2, (String)"java.util.Arrays.copyOf(this, size)");
        double[] temp = dArray2;
        int tsize = 0;
        int osize = this.size();
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            void n3;
            double c = this.get((int)n3);
            if (eset.contains(c) == retain) {
                temp[tsize++] = c;
            }
            ++n3;
        }
        this.data = temp;
        this._start = 0;
        this._size = tsize;
        return tsize != osize;
    }

    public final double getFirst() {
        return this.data[this._start];
    }

    public final double getLast() {
        return this.data[this.internalIndex(this.size() - 1)];
    }

    private final int internalIndex(int index) {
        return InternalKt.umod(this._start + index, this.getCapacity());
    }

    public final void set(int index, double value) {
        DoubleDeque doubleDeque = this;
        boolean bl = false;
        boolean bl2 = false;
        DoubleDeque $this$run = doubleDeque;
        boolean bl3 = false;
        $this$run.data[$this$run.internalIndex((int)index)] = value;
    }

    public final double get(int index) {
        return this.data[this.internalIndex(index)];
    }

    public boolean contains(double element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)this.size());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(this.get(it) == element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(double element) {
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            void n3;
            if (this.get((int)n3) == element) {
                return (int)n3;
            }
            ++n3;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block6: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Iterable $this$map$iv22 = elements;
            int $i$f$map = 0;
            Iterable iterable = $this$map$iv22;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                double d = ((Number)item$iv$iv).doubleValue();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)((double)it), (Object)0);
                collection.add(pair);
            }
            LinkedHashMap emap = _ExtensionsKt.toLinkedMap((List)destination$iv$iv);
            int $this$map$iv22 = 0;
            $i$f$map = this.size();
            while ($this$map$iv22 < $i$f$map) {
                void it;
                double e = this.get((int)it);
                Map $i$f$mapTo2 = emap;
                Double d = e;
                boolean bl3 = false;
                Map map = $i$f$mapTo2;
                boolean bl4 = false;
                if (map.containsKey(d)) {
                    ((Map)emap).put(e, 1);
                }
                ++it;
            }
            Collection collection = emap.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"emap.values");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Integer it = (Integer)element$iv;
                    boolean bl5 = false;
                    Integer n = it;
                    if (n != null && n == 1) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterator<Double> iterator() {
        DoubleDeque that = this;
        return new Iterator<Double>(this, that){
            private int index;
            final /* synthetic */ DoubleDeque this$0;
            final /* synthetic */ DoubleDeque $that;

            public final int getIndex() {
                return this.index;
            }

            public final void setIndex(int n) {
                this.index = n;
            }

            @NotNull
            public Double next() {
                int n = this.index;
                this.index = n + 1;
                return this.$that.get(n);
            }

            public boolean hasNext() {
                return this.index < this.this$0.size();
            }

            public void remove() {
                iterator.1 var1_1 = this;
                boolean bl = false;
                boolean bl2 = false;
                iterator.1 $this$run = var1_1;
                boolean bl3 = false;
                iterator.1 v0 = $this$run;
                v0.index += -1;
                this.this$0.removeAt(v0.index);
            }
            {
                this.this$0 = $outer;
                this.$that = $captured_local_variable$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var3_3;
        int size$iv = this.size();
        boolean $i$f$contentHashCode = false;
        int result$iv = 1;
        int n = 0;
        int n2 = size$iv;
        while (n < n2) {
            void it;
            Double d;
            void n$iv;
            void var6_7 = n$iv++;
            int n3 = 31 * result$iv;
            boolean bl = false;
            Double d2 = d = Double.valueOf(this.get((int)it));
            int n4 = n3;
            boolean bl2 = false;
            int n5 = ((Object)d2).hashCode();
            result$iv = n4 + n5;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DoubleDeque)) {
            return false;
        }
        if (((DoubleDeque)other).size() != this.size()) {
            return false;
        }
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            void n3;
            if (this.get((int)n3) != ((DoubleDeque)other).get((int)n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            void n3;
            sb.append(this.get((int)n3));
            if (n3 != this.size() - 1) {
                sb.append(", ");
            }
            ++n3;
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }
}

