/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.kds;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010*\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u000e\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\r\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/soywiz/kds/GenericListIterator;", "T", "", "list", "", "iindex", "", "(Ljava/util/List;I)V", "getIindex", "()I", "index", "getList", "()Ljava/util/List;", "hasNext", "", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "previous", "previousIndex", "kds_debug"})
public final class GenericListIterator<T>
implements ListIterator<T>,
KMappedMarker {
    private int index;
    @NotNull
    private final List<T> list;
    private final int iindex;

    @Override
    public boolean hasNext() {
        return this.index < this.list.size();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        int n = this.index;
        this.index = n + 1;
        return this.list.get(n);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public T previous() {
        if (!this.hasPrevious()) {
            throw (Throwable)new NoSuchElementException();
        }
        GenericListIterator genericListIterator = this;
        genericListIterator.index += -1;
        return this.list.get(genericListIterator.index);
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @NotNull
    public final List<T> getList() {
        return this.list;
    }

    public final int getIindex() {
        return this.iindex;
    }

    public GenericListIterator(@NotNull List<? extends T> list, int iindex) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.list = list;
        this.iindex = iindex;
        int n = this.iindex;
        if (0 > n || this.list.size() <= n) {
            throw (Throwable)new IndexOutOfBoundsException(String.valueOf(this.iindex));
        }
        this.index = this.iindex;
    }

    public /* synthetic */ GenericListIterator(List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(list, n);
    }

    @Override
    public void add(T t) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void set(T t) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

