package com.soywiz.kds

// AUTOGENERATED: DO NOT MODIFY MANUALLY!


/**
 * A LIFO (Last In First Out) structure.
 */
class Stack<TGen>() : Collection<TGen> {
    private val items = arrayListOf<TGen>()

    override val size: Int get() = items.size
    override fun isEmpty() = size == 0

    constructor(vararg items: TGen) : this() {
        for (item in items) push(item)
    }

    fun push(v: TGen) = run { items.add(v) }
    fun pop(): TGen = items.removeAt(items.size - 1)

    override fun contains(element: TGen): Boolean = items.contains(element)
    override fun containsAll(elements: Collection<TGen>): Boolean = items.containsAll(elements)
    override fun iterator(): Iterator<TGen> = items.iterator()
}


// Int

/**
 * A LIFO (Last In First Out) structure.
 */
class IntStack() : Collection<Int> {
    private val items = intArrayListOf()

    override val size: Int get() = items.size
    override fun isEmpty() = size == 0

    constructor(vararg items: Int) : this() {
        for (item in items) push(item)
    }

    fun push(v: Int) = run { items.add(v) }
    fun pop(): Int = items.removeAt(items.size - 1)

    override fun contains(element: Int): Boolean = items.contains(element)
    override fun containsAll(elements: Collection<Int>): Boolean = items.containsAll(elements)
    override fun iterator(): Iterator<Int> = items.iterator()
}


// Double

/**
 * A LIFO (Last In First Out) structure.
 */
class DoubleStack() : Collection<Double> {
    private val items = doubleArrayListOf()

    override val size: Int get() = items.size
    override fun isEmpty() = size == 0

    constructor(vararg items: Double) : this() {
        for (item in items) push(item)
    }

    fun push(v: Double) = run { items.add(v) }
    fun pop(): Double = items.removeAt(items.size - 1)

    override fun contains(element: Double): Boolean = items.contains(element)
    override fun containsAll(elements: Collection<Double>): Boolean = items.containsAll(elements)
    override fun iterator(): Iterator<Double> = items.iterator()
}


// Float

/**
 * A LIFO (Last In First Out) structure.
 */
class FloatStack() : Collection<Float> {
    private val items = floatArrayListOf()

    override val size: Int get() = items.size
    override fun isEmpty() = size == 0

    constructor(vararg items: Float) : this() {
        for (item in items) push(item)
    }

    fun push(v: Float) = run { items.add(v) }
    fun pop(): Float = items.removeAt(items.size - 1)

    override fun contains(element: Float): Boolean = items.contains(element)
    override fun containsAll(elements: Collection<Float>): Boolean = items.containsAll(elements)
    override fun iterator(): Iterator<Float> = items.iterator()
}
