/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model.indication;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.MultilineBuildLogFailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.BuildLogIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import hudson.Extension;
import hudson.model.Hudson;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class", visible=true)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MultilineBuildLogIndication
extends BuildLogIndication {
    private static final long serialVersionUID = 8436383594898812087L;
    private transient Pattern compiled = null;

    @DataBoundConstructor
    public MultilineBuildLogIndication(@JsonProperty(value="pattern") String pattern) {
        super(pattern);
    }

    @Override
    public FailureReader getReader() {
        return new MultilineBuildLogFailureReader(this);
    }

    @Override
    public Pattern getPattern() {
        if (this.compiled == null) {
            this.compiled = Pattern.compile("(?m)(?s)^[^\\r\\n]*?" + this.getUserProvidedExpression() + "[^\\r\\n]*?$", 40);
        }
        return this.compiled;
    }

    @Override
    public Indication.IndicationDescriptor getDescriptor() {
        return (Indication.IndicationDescriptor)Hudson.getInstance().getDescriptorByType(MultilineBuildLogIndicationDescriptor.class);
    }

    @Extension
    public static class MultilineBuildLogIndicationDescriptor
    extends BuildLogIndication.BuildLogIndicationDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.MultilineBuildLogIndication_DisplayName();
        }

        @Override
        protected FailureReader getFailureReader(String testPattern) {
            return new MultilineBuildLogFailureReader(new MultilineBuildLogIndication(testPattern));
        }
    }
}

