/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.sod;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.sod.ScanOnDemandQueue;
import com.sonyericsson.jenkins.plugins.bfa.sod.ScanOnDemandTask;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.util.Iterators;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ScanOnDemandBaseAction
implements Action {
    private Job project;

    public ScanOnDemandBaseAction(Job project) {
        this.project = project;
    }

    public String getIconFileName() {
        if (this.hasPermission()) {
            return PluginImpl.getDefaultIcon();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.hasPermission()) {
            return Messages.FailureScan_DisplayName();
        }
        return null;
    }

    public String getUrlName() {
        if (this.hasPermission()) {
            return "scan-on-demand";
        }
        return null;
    }

    @CheckForNull
    private String getFullUrl() {
        if (this.getUrlName() == null) {
            return null;
        }
        return Functions.joinPath((String[])new String[]{this.project.getUrl(), this.getUrlName()});
    }

    public boolean hasPermission() {
        return this.project.hasPermission(Item.CONFIGURE) || this.project.hasPermission(Project.BUILD);
    }

    public void checkPermission() {
        if (!this.hasPermission()) {
            throw new AccessDeniedException(Messages.SodAccessDeniedException(Jenkins.getAuthentication().getName(), Item.CONFIGURE.name, Project.BUILD.name));
        }
    }

    public final Job<?, ?> getProject() {
        return this.project;
    }

    public void removeRunActions(MatrixBuild build) {
        List runs = build.getRuns();
        for (MatrixRun run : runs) {
            FailureCauseMatrixBuildAction fcmba;
            if (run.getNumber() != build.getNumber()) continue;
            FailureCauseBuildAction fcba = (FailureCauseBuildAction)run.getAction(FailureCauseBuildAction.class);
            if (fcba != null) {
                run.getActions().remove(fcba);
            }
            if ((fcmba = (FailureCauseMatrixBuildAction)run.getAction(FailureCauseMatrixBuildAction.class)) == null) continue;
            run.getActions().remove(fcmba);
        }
    }

    public void doPerformScan(StaplerRequest request, StaplerResponse response) throws ServletException, InterruptedException, IOException {
        this.getDefault().doPerformScan(this, request, response);
    }

    public ScanMode getDefault() {
        ScanMode mode;
        String selected;
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null && !StringUtils.isBlank((String)(selected = (String)request.getSession(true).getAttribute("bfa-sod-buildType"))) && (mode = this.getMode(selected)) != null) {
            return mode;
        }
        return this.getMode("nonscanned");
    }

    public Object getDynamic(String url) {
        if (StringUtils.isBlank((String)url)) {
            return this.getDefault();
        }
        return this.getMode(url);
    }

    public ScanMode getMode(String url) {
        for (ScanMode mode : ExtensionList.lookup(ScanMode.class)) {
            if (!mode.getUrlName().equals(url)) continue;
            return mode;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public static abstract class ScanMode
    implements ExtensionPoint {
        static final String BFA_SOD_BUILD_TYPE = "bfa-sod-buildType";

        public boolean hasAnyRun(Job job) {
            return this.getRuns(job).hasNext();
        }

        @NonNull
        public abstract String getUrlName();

        @CheckForNull
        public String getFullUrl() {
            String fullUrl = this.getParent().getFullUrl();
            if (fullUrl == null) {
                return null;
            }
            return Functions.joinPath((String[])new String[]{fullUrl, this.getUrlName()});
        }

        @NonNull
        public abstract String getDisplayName();

        @NonNull
        abstract Iterator<Run> getRuns(Job var1);

        public void setAsDefault() {
            StaplerRequest request = Stapler.getCurrentRequest();
            if (request == null) {
                throw new IllegalStateException("setAsDefault() can only be called in request scope");
            }
            request.getSession(true).setAttribute(BFA_SOD_BUILD_TYPE, (Object)this.getUrlName());
        }

        @NonNull
        public ScanOnDemandBaseAction getParent() {
            StaplerRequest request = Stapler.getCurrentRequest();
            if (request == null) {
                throw new IllegalStateException("getParent can only be called from request scope.");
            }
            Ancestor ancestor = request.findAncestor(ScanOnDemandBaseAction.class);
            if (ancestor == null) {
                throw new IllegalStateException("Not within the path of ScanOnDemandBaseAction");
            }
            ScanOnDemandBaseAction object = (ScanOnDemandBaseAction)ancestor.getObject();
            if (object == null) {
                throw new IllegalStateException("Not within the path of ScanOnDemandBaseAction");
            }
            return object;
        }

        public void doPerformScan(@AncestorInPath ScanOnDemandBaseAction action, StaplerRequest request, StaplerResponse response) throws ServletException, IOException, InterruptedException {
            action.checkPermission();
            Iterator<Run> runIterator = this.getRuns(action.getProject());
            while (runIterator.hasNext()) {
                Run run = runIterator.next();
                FailureCauseBuildAction fcba = (FailureCauseBuildAction)run.getAction(FailureCauseBuildAction.class);
                if (fcba != null) {
                    run.getActions().remove(fcba);
                }
                FailureCauseMatrixBuildAction fcmba = (FailureCauseMatrixBuildAction)run.getAction(FailureCauseMatrixBuildAction.class);
                if (run instanceof MatrixBuild && fcmba != null) {
                    run.getActions().remove(fcmba);
                    action.removeRunActions((MatrixBuild)run);
                }
                ScanOnDemandTask task = new ScanOnDemandTask(run);
                ScanOnDemandQueue.queue(task);
            }
            response.sendRedirect2(Functions.joinPath((String[])new String[]{"/", request.getContextPath(), this.getParent().getProject().getUrl()}));
        }

        public static List<ScanMode> all() {
            return ExtensionList.lookup(ScanMode.class);
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class NonScanned
    extends ScanMode {
        static final String URL = "nonscanned";

        @Override
        @NonNull
        public String getUrlName() {
            return URL;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.ScanOnDemandBaseAction_NonScanned_DisplayName();
        }

        @Override
        @NonNull
        Iterator<Run> getRuns(Job job) {
            return new Iterators.FilterIterator<Run>(job.getBuilds().iterator()){

                protected boolean filter(Run run) {
                    Result result = run.getResult();
                    return result != null && PluginImpl.needToAnalyze(result) && run.getActions(FailureCauseBuildAction.class).isEmpty() && run.getActions(FailureCauseMatrixBuildAction.class).isEmpty();
                }
            };
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class AllBuilds
    extends ScanMode {
        @Override
        @NonNull
        public String getUrlName() {
            return "all";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.ScanOnDemandBaseAction_AllBuilds_DisplayName();
        }

        @Override
        @NonNull
        Iterator<Run> getRuns(Job job) {
            return new Iterators.FilterIterator<Run>(job.getBuilds().iterator()){

                protected boolean filter(Run run) {
                    Result result = run.getResult();
                    return result != null && PluginImpl.needToAnalyze(result);
                }
            };
        }
    }
}

