/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model;

import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class FoundFailureCause {
    private static final Logger logger = Logger.getLogger(FoundFailureCause.class.getName());
    private final String id;
    private final String name;
    private final String description;
    private final List<String> categories;
    private List<FoundIndication> indications;

    public FoundFailureCause(FailureCause originalCause) {
        this(originalCause, new LinkedList<FoundIndication>());
    }

    public FoundFailureCause(FailureCause originalCause, List<FoundIndication> indications) {
        this.id = originalCause.getId();
        this.name = originalCause.getName();
        this.categories = originalCause.getCategories();
        this.indications = new LinkedList<FoundIndication>(indications);
        this.description = FoundFailureCause.buildFormattedDescription(originalCause, this.indications, originalCause.getDescription());
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    @Exported
    public List<String> getCategories() {
        return this.categories;
    }

    public List<FoundIndication> getIndications() {
        if (this.indications == null) {
            this.indications = new LinkedList<FoundIndication>();
        }
        return this.indications;
    }

    @Deprecated
    public void addIndication(FoundIndication indication) {
        this.indications.add(indication);
    }

    @Deprecated
    public void addIndications(List<FoundIndication> foundIndications) {
        this.indications.addAll(foundIndications);
    }

    private static String buildFormattedDescription(FailureCause originalCause, List<FoundIndication> foundIndications, String description) {
        String formattedDescription = description;
        if (!foundIndications.isEmpty()) {
            FoundIndication firstFoundIndication = foundIndications.get(0);
            try {
                if (originalCause != null) {
                    int expressionIndex;
                    List<Indication> originalCauseIndications = originalCause.getIndications();
                    boolean foundExpressionIndex = false;
                    int size = originalCauseIndications.size();
                    for (expressionIndex = 0; expressionIndex < size; ++expressionIndex) {
                        if (!originalCauseIndications.get(expressionIndex).getPattern().pattern().equals(firstFoundIndication.getPattern())) continue;
                        foundExpressionIndex = true;
                        break;
                    }
                    if (foundExpressionIndex) {
                        int expressionNumber = expressionIndex + 1;
                        formattedDescription = FoundFailureCause.convertFormat(formattedDescription, expressionNumber);
                        Pattern contentPattern = Pattern.compile(firstFoundIndication.getPattern());
                        Matcher contentMatcher = contentPattern.matcher(firstFoundIndication.getMatchingString());
                        formattedDescription = contentMatcher.replaceAll(formattedDescription);
                    }
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, null, exception);
            }
        }
        return formattedDescription;
    }

    static String convertFormat(String input, int expressionNumber) {
        Pattern expressionPattern = Pattern.compile("(?<!\\\\)\\$\\{\\s*" + Integer.toString(expressionNumber) + "\\s*,\\s*(\\d+?)\\s*\\}");
        Matcher expressionMatcher = expressionPattern.matcher(input);
        String expressionTokensReplaced = expressionMatcher.replaceAll("\\$$1");
        Pattern nonExpressionPattern = Pattern.compile("(?<!\\\\)\\$\\{\\s*\\d+?\\s*,\\s*\\d+?\\s*\\}");
        Matcher nonExpressionMatcher = nonExpressionPattern.matcher(expressionTokensReplaced);
        String nonExpressionTokensRemoved = nonExpressionMatcher.replaceAll("");
        Pattern escapedTokenPattern = Pattern.compile("\\\\(\\$\\{\\s*\\d+?\\s*,\\s*\\d+?\\s*\\})");
        Matcher escapedTokenMatcher = escapedTokenPattern.matcher(nonExpressionTokensRemoved);
        return escapedTokenMatcher.replaceAll("$1");
    }
}

