/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphCache;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphType;
import hudson.model.ModelObject;
import hudson.model.RootAction;
import hudson.util.Graph;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.kohsuke.stapler.StaplerRequest;

public abstract class BfaGraphAction
implements RootAction {
    protected static final String URL_PARAM_TIME_PERIOD = "time";
    protected static final String URL_PARAM_WHICH_GRAPH = "which";
    protected static final String URL_PARAM_SHOW_ABORTED = "showAborted";
    protected static final String URL_PARAM_ALL_MASTERS = "allMasters";
    protected static final String URL_PARAM_VALUE_TODAY = "today";
    protected static final String URL_PARAM_VALUE_MONTH = "month";
    protected static final String URL_PARAM_VALUE_MAX = "max";
    protected static final int DEFAULT_GRAPH_WIDTH = 700;
    protected static final int DEFAULT_GRAPH_HEIGHT = 500;
    protected static final String EXCLUDE_ABORTED = "ABORTED";
    protected static final char ID_SEPARATOR = '-';

    public abstract ModelObject getOwner();

    public abstract GraphType[] getGraphTypes();

    public abstract String getGraphsPageTitle();

    protected abstract Graph getGraph(GraphType var1, Date var2, boolean var3, boolean var4, Map<String, String> var5);

    public Graph getGraph(StaplerRequest req) {
        final HashMap<String, String> rawReqParams = new HashMap<String, String>();
        String reqTimePeriod = req.getParameter(URL_PARAM_TIME_PERIOD);
        if (reqTimePeriod == null || !reqTimePeriod.matches("month|max")) {
            reqTimePeriod = URL_PARAM_VALUE_TODAY;
        }
        rawReqParams.put(URL_PARAM_TIME_PERIOD, reqTimePeriod);
        String reqWhich = req.getParameter(URL_PARAM_WHICH_GRAPH);
        rawReqParams.put(URL_PARAM_WHICH_GRAPH, reqWhich);
        String showAborted = req.getParameter(URL_PARAM_SHOW_ABORTED);
        rawReqParams.put(URL_PARAM_SHOW_ABORTED, showAborted);
        String allMasters = req.getParameter(URL_PARAM_ALL_MASTERS);
        rawReqParams.put(URL_PARAM_ALL_MASTERS, allMasters);
        final Date sinceDate = this.getDateForUrlStr(reqTimePeriod);
        int tmpWhichGraph = -1;
        try {
            tmpWhichGraph = Integer.parseInt(reqWhich);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        final GraphType whichGraph = GraphType.toEnum(tmpWhichGraph);
        final boolean hideAborted = "0".equals(showAborted);
        final boolean forAllMasters = "1".equals(allMasters);
        String id = this.getGraphCacheId(whichGraph, reqTimePeriod, hideAborted, forAllMasters);
        Graph graphToReturn = null;
        try {
            graphToReturn = GraphCache.getInstance().get(id, new Callable<Graph>(){

                @Override
                public Graph call() throws Exception {
                    Graph g = BfaGraphAction.this.getGraph(whichGraph, sinceDate, hideAborted, forAllMasters, rawReqParams);
                    if (g != null) {
                        return g;
                    }
                    throw new ExecutionException("Graph-parameters not valid", null);
                }
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return graphToReturn;
    }

    protected abstract String getGraphCacheId(GraphType var1, String var2, boolean var3, boolean var4);

    public int getDefaultGraphWidth() {
        return 700;
    }

    public int getDefaultGraphHeight() {
        return 500;
    }

    public boolean showMasterSwitch() {
        return false;
    }

    public boolean showGraphDelayText() {
        return false;
    }

    private Date getDateForUrlStr(String str) {
        Calendar cal = Calendar.getInstance();
        Date date = null;
        if (URL_PARAM_VALUE_TODAY.equals(str)) {
            cal.add(6, -1);
            date = cal.getTime();
        } else if (URL_PARAM_VALUE_MONTH.equals(str)) {
            cal.add(2, -1);
            date = cal.getTime();
        }
        return date;
    }
}

