/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model.indication;

import com.sonyericsson.jenkins.plugins.bfa.utils.OldDataConverter;
import hudson.model.AbstractBuild;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FoundIndication {
    protected static final String FILE_ENCODING = System.getProperty("file.encoding");
    private String matchingFile;
    @Deprecated
    private transient Integer matchingLine;
    private String pattern;
    private AbstractBuild build;
    private String matchingString;

    public FoundIndication(AbstractBuild build, String originalPattern, String matchingFile, String matchingString) {
        this.pattern = originalPattern;
        this.matchingFile = matchingFile;
        this.build = build;
        this.matchingString = matchingString;
    }

    @JsonCreator
    public FoundIndication(@JsonProperty(value="pattern") String pattern, @JsonProperty(value="matchingFile") String matchingFile, @JsonProperty(value="matchingString") String matchingString) {
        this.pattern = pattern;
        this.matchingFile = matchingFile;
        this.matchingString = matchingString;
    }

    public String getMatchingFile() {
        return this.matchingFile;
    }

    public String getPattern() {
        return this.pattern;
    }

    public AbstractBuild getBuild() {
        return this.build;
    }

    public String getMatchingString() {
        return this.matchingString;
    }

    public void convertFromLineNumber(List<String> log) {
        if (this.matchingLine != null && log.size() >= this.matchingLine) {
            this.matchingString = log.get(Math.max(0, this.matchingLine - 1));
        }
    }

    public Object readResolve() {
        if (this.matchingLine != null && (this.matchingString == null || this.matchingString.isEmpty())) {
            OldDataConverter.getInstance().convertFoundIndications(this.build);
        }
        return this;
    }

    @Deprecated
    public int getMatchingLine() {
        if (this.matchingLine != null) {
            return this.matchingLine;
        }
        return -1;
    }

    public int getMatchingHash() {
        if (this.matchingString != null) {
            return this.matchingString.hashCode();
        }
        return 0;
    }
}

