/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.statistics;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.statistics.FailureCauseStatistics;
import com.sonyericsson.jenkins.plugins.bfa.statistics.Statistics;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public final class StatisticsLogger {
    private static final Logger logger = Logger.getLogger(StatisticsLogger.class.getName());
    private static StatisticsLogger instance;
    private ExecutorService queueExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable target) {
            return new Thread(target, "BFA StatisticsLogger Queue");
        }
    });

    private StatisticsLogger() {
    }

    public static synchronized StatisticsLogger getInstance() {
        if (instance == null) {
            instance = new StatisticsLogger();
        }
        return instance;
    }

    public void log(AbstractBuild build, List<FoundFailureCause> causes) {
        if (PluginImpl.getInstance().getKnowledgeBase().isStatisticsEnabled()) {
            this.queueExecutor.submit(new LoggingWork(build, causes));
        }
    }

    static class LoggingWork
    implements Runnable {
        List<FoundFailureCause> causes;
        AbstractBuild build;

        LoggingWork(AbstractBuild build, List<FoundFailureCause> causes) {
            this.build = build;
            this.causes = causes;
        }

        @Override
        public void run() {
            String projectName = this.build.getProject().getFullName();
            int buildNumber = this.build.getNumber();
            Date startingTime = this.build.getTime();
            long duration = this.build.getDuration();
            LinkedList<String> triggerCauses = new LinkedList<String>();
            for (Object o : this.build.getCauses()) {
                triggerCauses.add(o.getClass().getSimpleName());
            }
            Node node = this.build.getBuiltOn();
            String nodeName = node.getNodeName();
            int timeZoneOffset = TimeZone.getDefault().getRawOffset();
            String master = "";
            String result = this.build.getResult().toString();
            LinkedList<FailureCauseStatistics> failureCauseStatistics = new LinkedList<FailureCauseStatistics>();
            for (FoundFailureCause cause : this.causes) {
                FailureCauseStatistics stats = new FailureCauseStatistics(cause.getId(), cause.getIndications());
                failureCauseStatistics.add(stats);
            }
            try {
                String masterString = Jenkins.getInstance().getRootUrl();
                master = new URL(masterString).getHost();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Couldn't get name of master: ", e);
            }
            Statistics obj = new Statistics(projectName, buildNumber, startingTime, duration, triggerCauses, nodeName, master, timeZoneOffset, result, failureCauseStatistics);
            try {
                PluginImpl p = PluginImpl.getInstance();
                KnowledgeBase kb = p.getKnowledgeBase();
                kb.saveStatistics(obj);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Couldn't save statistics: ", e);
            }
        }
    }
}

