/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model.indication;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.model.BuildLogFailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import java.util.regex.PatternSyntaxException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BuildLogIndication
extends Indication {
    @DataBoundConstructor
    public BuildLogIndication(String pattern) {
        super(pattern);
    }

    public BuildLogIndication() {
    }

    @Override
    public FailureReader getReader() {
        return new BuildLogFailureReader(this);
    }

    public Indication.IndicationDescriptor getDescriptor() {
        return (Indication.IndicationDescriptor)Hudson.getInstance().getDescriptorByType(BuildLogIndicationDescriptor.class);
    }

    @Extension
    public static class BuildLogIndicationDescriptor
    extends Indication.IndicationDescriptor {
        public String getDisplayName() {
            return Messages.BuildLogIndication_DisplayName();
        }

        public FormValidation doMatchText(@QueryParameter(value="pattern") String testPattern, @QueryParameter(value="testText") String testText) {
            try {
                if (testText.matches(testPattern)) {
                    return FormValidation.ok((String)Messages.StringMatchesPattern());
                }
                return FormValidation.warning((String)Messages.StringDoesNotMatchPattern());
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)Messages.InvalidPattern_Error());
            }
        }
    }
}

