/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model;

import com.sonyericsson.jenkins.plugins.bfa.CauseManagement;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseModification;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.User;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import net.vz.mongodb.jackson.Id;
import net.vz.mongodb.jackson.ObjectId;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonIgnoreType;
import org.codehaus.jackson.annotate.JsonProperty;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FailureCause
implements Serializable,
Action,
Describable<FailureCause> {
    private static final Logger logger = Logger.getLogger(FailureCause.class.getName());
    private String id;
    private String name;
    private String description;
    private String comment;
    private Date lastOccurred;
    private List<String> categories;
    private List<Indication> indications;
    private List<FailureCauseModification> modifications;

    @DataBoundConstructor
    public FailureCause(String id, String name, String description, String comment, Date lastOccurred, String categories, List<Indication> indications, List<FailureCauseModification> modifications) {
        this(id, name, description, comment, lastOccurred, Arrays.asList(Util.tokenize((String)categories)), indications, modifications);
    }

    @JsonCreator
    public FailureCause(@Id @ObjectId String id, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="comment") String comment, @JsonProperty(value="occurred") Date lastOccurred, @JsonProperty(value="categories") List<String> categories, @JsonProperty(value="indications") List<Indication> indications, @JsonProperty(value="modifications") List<FailureCauseModification> modifications) {
        this.id = Util.fixEmpty((String)id);
        this.name = name;
        this.description = description;
        this.comment = comment;
        this.lastOccurred = lastOccurred == null ? null : (Date)lastOccurred.clone();
        this.categories = categories;
        this.indications = indications;
        if (this.indications == null) {
            this.indications = new LinkedList<Indication>();
        }
        this.modifications = modifications;
        if (this.modifications == null) {
            this.modifications = new LinkedList<FailureCauseModification>();
        }
    }

    public FailureCause(String name, String description) {
        this(null, name, description, "", null, "", null, null);
    }

    public FailureCause(String name, String description, String comment) {
        this(null, name, description, comment, null, "", null, null);
    }

    public FailureCause() {
    }

    public FormValidation validate(String newName, String newDescription, List<Indication> newIndications) {
        FormValidation nameVal = this.doCheckName(newName);
        if (nameVal.kind != FormValidation.Kind.OK) {
            return nameVal;
        }
        FormValidation descriptionVal = this.doCheckDescription(newDescription);
        if (descriptionVal.kind != FormValidation.Kind.OK) {
            return descriptionVal;
        }
        if (newIndications == null || newIndications.isEmpty()) {
            return FormValidation.error((String)("Need at least one indication for " + newName));
        }
        for (Indication indication : newIndications) {
            FormValidation validation = indication.validate();
            if (validation.kind == FormValidation.Kind.OK) continue;
            return validation;
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckDescription(@QueryParameter String value) {
        if (Util.fixEmpty((String)value) == null) {
            return FormValidation.error((String)"You should provide a description.");
        }
        if ("Description...".equalsIgnoreCase(value.trim())) {
            return FormValidation.error((String)"Bad description.");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckName(@QueryParameter String value) {
        if (Util.fixEmpty((String)value) == null) {
            return FormValidation.error((String)"You must provide a name for the failure cause!");
        }
        if ("New...".equalsIgnoreCase(value)) {
            return FormValidation.error((String)"Reserved name!");
        }
        try {
            Jenkins.checkGoodName((String)value);
        }
        catch (Failure failure) {
            return FormValidation.error((Throwable)failure, (String)failure.getMessage());
        }
        try {
            for (FailureCause other : PluginImpl.getInstance().getKnowledgeBase().getCauses()) {
                if (this.id != null && this.id.equals(other.getId()) || !value.equals(other.getName())) continue;
                return FormValidation.error((String)"There is another cause with that name.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get causes list to evaluate name! ", e);
        }
        return FormValidation.ok();
    }

    public synchronized void doConfigSubmit(StaplerRequest request, StaplerResponse response) throws Exception {
        logger.entering(this.getClass().getName(), "doConfigSubmit");
        Jenkins.getInstance().checkPermission(PluginImpl.UPDATE_PERMISSION);
        JSONObject form = request.getSubmittedForm();
        String newId = form.getString("id");
        newId = Util.fixEmpty((String)newId);
        String oldId = Util.fixEmpty((String)this.id);
        if (newId != null) {
            if (oldId != null && !newId.equals(oldId)) {
                throw new Failure("Attempt at changing the wrong cause! Expected [" + this.id + "] but got [" + newId + "]");
            }
            if (oldId == null) {
                throw new Failure("Attempt at setting id of new cause!");
            }
        } else if (oldId != null) {
            throw new Failure("Clone attempt of cause [" + this.id + "]");
        }
        String newName = form.getString("name");
        String newDescription = form.getString("description");
        String newComment = form.getString("comment");
        String jsonCategories = form.optString("categories");
        this.categories = Util.fixEmpty((String)jsonCategories) != null ? Arrays.asList(Util.tokenize((String)jsonCategories)) : null;
        Object jsonIndications = form.opt("indications");
        if (jsonIndications == null) {
            throw new Failure("You need to provide at least one indication!");
        }
        List newIndications = request.bindJSONToList(Indication.class, jsonIndications);
        FormValidation validation = this.validate(newName, newDescription, newIndications);
        if (validation.kind != FormValidation.Kind.OK) {
            throw validation;
        }
        this.name = newName;
        this.description = newDescription;
        this.comment = newComment;
        this.indications = newIndications;
        String user = null;
        try {
            user = User.current().getId();
        }
        catch (NullPointerException npe) {
            logger.log(Level.INFO, "Failed to get user for Failure Cause modification");
        }
        this.modifications.add(0, new FailureCauseModification(user, new Date()));
        if (newId == null) {
            PluginImpl.getInstance().getKnowledgeBase().addCause(this);
        } else {
            PluginImpl.getInstance().getKnowledgeBase().saveCause(this);
        }
        response.sendRedirect2("../");
    }

    public void addIndication(Indication indication) {
        if (this.indications == null) {
            this.indications = new LinkedList<Indication>();
        }
        this.indications.add(indication);
    }

    @Id
    @ObjectId
    public String getId() {
        return this.id;
    }

    @Id
    @ObjectId
    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getLastOccurred() {
        if (this.lastOccurred != null) {
            return (Date)this.lastOccurred.clone();
        }
        return null;
    }

    @JsonIgnore
    public Date getAndInitiateLastOccurred() {
        if (this.lastOccurred == null && this.id != null) {
            this.loadLastOccurred();
        }
        if (this.lastOccurred != null) {
            return (Date)this.lastOccurred.clone();
        }
        return null;
    }

    public void setLastOccurred(Date lastOccurred) {
        this.lastOccurred = lastOccurred == null ? null : (Date)lastOccurred.clone();
    }

    public List<FailureCauseModification> getModifications() {
        return this.modifications;
    }

    @JsonIgnore
    public List<FailureCauseModification> getAndInitiateModifications() {
        if ((this.modifications == null || this.modifications.isEmpty()) && this.id != null) {
            this.initModifications();
        }
        return this.modifications;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    @JsonIgnore
    public String getCategoriesAsString() {
        if (this.categories == null || this.categories.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String item : this.categories) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(item);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModifications() {
        FailureCause originalCause;
        FailureCauseModification creation;
        KnowledgeBase kb;
        block9: {
            if (this.modifications == null) {
                this.modifications = new LinkedList<FailureCauseModification>();
            }
            kb = PluginImpl.getInstance().getKnowledgeBase();
            Date creationDate = kb.getCreationDateForCause(this.id);
            creation = new FailureCauseModification(null, creationDate);
            this.modifications.add(creation);
            originalCause = null;
            try {
                originalCause = kb.getCause(this.id);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Got exception when loading the original FailureCause");
            }
            finally {
                if (originalCause != null) break block9;
                logger.warning("Original FailureCause was null");
                return;
            }
        }
        if (originalCause.modifications == null) {
            originalCause.modifications = new LinkedList<FailureCauseModification>();
        }
        originalCause.modifications.add(creation);
        try {
            kb.saveCause(originalCause);
        }
        catch (Exception e) {
            logger.warning("Failed saving failure cause modification to knowledgeBase");
        }
    }

    @JsonIgnore
    public FailureCauseModification getLatestModification() {
        FailureCauseModification latestMod;
        List<FailureCauseModification> mods = this.getAndInitiateModifications();
        if (mods != null && !mods.isEmpty() && (latestMod = mods.get(0)).getTime().getTime() > 0L) {
            return latestMod;
        }
        return null;
    }

    private void loadLastOccurred() {
        this.lastOccurred = PluginImpl.getInstance().getKnowledgeBase().getLatestFailureForCause(this.id);
        if (this.lastOccurred == null) {
            this.lastOccurred = new Date(0L);
        }
        try {
            FailureCause originalCause = PluginImpl.getInstance().getKnowledgeBase().getCause(this.id);
            originalCause.setLastOccurred(this.lastOccurred);
            PluginImpl.getInstance().getKnowledgeBase().saveCause(originalCause);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed updating lastOccurred", e);
        }
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public List<Indication> getIndications() {
        if (this.indications == null) {
            this.indications = new LinkedList<Indication>();
        }
        return this.indications;
    }

    @JsonIgnore
    public CauseManagement getAncestorCauseManagement() {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        if (currentRequest == null) {
            return null;
        }
        CauseManagement ancestorObject = (CauseManagement)currentRequest.findAncestorObject(CauseManagement.class);
        if (ancestorObject == null) {
            return null;
        }
        return ancestorObject;
    }

    @JsonIgnore
    public String getIconFileName() {
        return PluginImpl.getDefaultIcon();
    }

    @JsonIgnore
    public String getDisplayName() {
        return this.name;
    }

    @JsonIgnore
    public String getUrlName() {
        return this.id;
    }

    public FailureCauseDescriptor getDescriptor() {
        return (FailureCauseDescriptor)Jenkins.getInstance().getDescriptorByType(FailureCauseDescriptor.class);
    }

    @Extension
    @JsonIgnoreType
    public static final class FailureCauseDescriptor
    extends Descriptor<FailureCause> {
        private static final String LAST_FAILED_BUILD_URL_SESSION_ATTRIBUTE_NAME = "BFA_LAST_FAILED_BUILD_URL";

        public String getLastFailedBuildUrl() {
            String answer;
            StaplerRequest staplerRequest = Stapler.getCurrentRequest();
            if (staplerRequest != null && (answer = (String)staplerRequest.getSession(true).getAttribute(LAST_FAILED_BUILD_URL_SESSION_ATTRIBUTE_NAME)) != null) {
                return answer;
            }
            return "";
        }

        public void setLastFailedBuildUrl() {
            StaplerRequest staplerRequest = Stapler.getCurrentRequest();
            if (staplerRequest != null) {
                Job project = (Job)staplerRequest.findAncestorObject(Job.class);
                if (project != null && project.getLastFailedBuild() != null) {
                    staplerRequest.getSession(true).setAttribute(LAST_FAILED_BUILD_URL_SESSION_ATTRIBUTE_NAME, (Object)(Hudson.getInstance().getRootUrl() + project.getLastFailedBuild().getUrl()));
                } else {
                    staplerRequest.getSession(true).setAttribute(LAST_FAILED_BUILD_URL_SESSION_ATTRIBUTE_NAME, (Object)"");
                }
            }
        }

        public String getDisplayName() {
            return "";
        }

        public AutoCompletionCandidates doAutoCompleteCategories(@QueryParameter String value) {
            List<String> categories;
            try {
                categories = PluginImpl.getInstance().getKnowledgeBase().getCategories();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not get the categories for autocompletion", e);
                return null;
            }
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            if (categories == null) {
                return candidates;
            }
            for (String category : categories) {
                if (!category.toLowerCase().startsWith(value.toLowerCase())) continue;
                candidates.add(category);
            }
            return candidates;
        }
    }
}

