/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model.indication;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FoundIndication {
    protected static final String FILE_ENCODING = System.getProperty("file.encoding");
    private String matchingFile;
    private int matchingLine;
    private String pattern;
    private AbstractBuild build;
    private static final int CONTEXT = 10;
    private static final Logger logger = Logger.getLogger(FoundIndication.class.getName());

    public FoundIndication(AbstractBuild build, String originalPattern, String matchingFile, int matchingLine) {
        this.pattern = originalPattern;
        this.matchingFile = matchingFile;
        this.matchingLine = matchingLine;
        this.build = build;
    }

    public String getMatchingFile() {
        return this.matchingFile;
    }

    public int getMatchingLine() {
        return this.matchingLine;
    }

    public String getPattern() {
        return this.pattern;
    }

    public AbstractBuild getBuild() {
        return this.build;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModifiedLog() {
        StringBuilder builder = new StringBuilder("<pre>");
        int currentLineNumber = 1;
        int focusLine = this.matchingLine < 10 ? 1 : this.matchingLine - 10;
        File rootDir = this.build.getRootDir();
        File inputFile = new File(rootDir, this.matchingFile);
        BufferedReader br = null;
        try {
            String currentLine;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), FILE_ENCODING));
            while ((currentLine = br.readLine()) != null) {
                MarkupText markup = new MarkupText(currentLine);
                currentLine = markup.toString(true);
                if (currentLineNumber == focusLine) {
                    if (currentLineNumber == this.matchingLine) {
                        builder.append("<span class=\"errorLine\" id=\"focusLine\">");
                        builder.append(currentLine);
                        builder.append("</span>\n");
                    } else {
                        builder.append("<span id=\"focusLine\">");
                        builder.append(currentLine);
                        builder.append("</span>\n");
                    }
                } else if (currentLineNumber == this.matchingLine) {
                    builder.append("<span class=\"errorLine\">");
                    builder.append(currentLine);
                    builder.append("</span>\n");
                } else if (currentLineNumber != focusLine && currentLineNumber != this.matchingLine) {
                    builder.append(currentLine);
                    builder.append("\n");
                }
                ++currentLineNumber;
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "[BFA] Could not open reader for build: " + this.build.getDisplayName() + " and Indication: " + this.pattern, e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "[BFA] I/O problems during build log modification for build:" + this.build.getDisplayName() + " and Indication: " + this.pattern, e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close the reader. ", e);
                }
            }
        }
        builder.append("</pre>");
        return builder.toString();
    }
}

