/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.statistics;

import com.sonyericsson.jenkins.plugins.bfa.statistics.FailureCauseStatistics;
import hudson.model.Cause;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Statistics {
    private String projectName;
    private int buildNumber;
    private String displayName;
    private Date startingTime;
    private long duration;
    private List<String> triggerCauses;
    private String slave;
    private String master;
    private int timeZoneOffset;
    private String result;
    private UpstreamCause upstreamCause;
    private List<FailureCauseStatistics> failureCauseStatisticsList;

    public String getProjectName() {
        return this.projectName;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getStartingTime() {
        if (this.startingTime == null) {
            return null;
        }
        return new Date(this.startingTime.getTime());
    }

    public long getDuration() {
        return this.duration;
    }

    public List<String> getTriggerCauses() {
        return this.triggerCauses;
    }

    public String getSlaveHostName() {
        return this.slave;
    }

    public String getMaster() {
        return this.master;
    }

    public int getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public String getResult() {
        return this.result;
    }

    public UpstreamCause getUpstreamCause() {
        return this.upstreamCause;
    }

    public List<FailureCauseStatistics> getFailureCauseStatisticsList() {
        return this.failureCauseStatisticsList;
    }

    @JsonCreator
    public Statistics(@JsonProperty(value="projectName") String projectName, @JsonProperty(value="buildNumber") int buildNumber, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="startingTime") Date startingTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="triggerCauses") List<String> triggerCauses, @JsonProperty(value="slaveHostName") String nodeName, @JsonProperty(value="master") String master, @JsonProperty(value="timeZoneOffset") int timeZoneOffset, @JsonProperty(value="result") String result, @JsonProperty(value="upstreamCause") UpstreamCause upstreamCause, @JsonProperty(value="failureCauses") List<FailureCauseStatistics> failureCauseStatistics) {
        this.projectName = projectName;
        this.buildNumber = buildNumber;
        this.displayName = displayName;
        this.startingTime = startingTime == null ? null : new Date(startingTime.getTime());
        this.duration = duration;
        this.triggerCauses = triggerCauses;
        this.slave = nodeName;
        this.master = master;
        this.timeZoneOffset = timeZoneOffset;
        this.result = result;
        this.upstreamCause = upstreamCause;
        this.failureCauseStatisticsList = failureCauseStatistics;
    }

    @Deprecated
    public Statistics(String projectName, int buildNumber, Date startingTime, long duration, List<String> triggerCauses, String nodeName, String master, int timeZoneOffset, String result, List<FailureCauseStatistics> failureCauseStatistics) {
        this(projectName, buildNumber, null, startingTime, duration, triggerCauses, nodeName, master, timeZoneOffset, result, null, failureCauseStatistics);
    }

    public static class UpstreamCause {
        private String project;
        private int build;

        @JsonCreator
        public UpstreamCause(@JsonProperty(value="project") String project, @JsonProperty(value="build") int build) {
            this.project = project;
            this.build = build;
        }

        public UpstreamCause(Cause.UpstreamCause upstreamCause) {
            if (upstreamCause == null) {
                this.project = "";
                this.build = 0;
            } else {
                this.project = upstreamCause.getUpstreamProject();
                this.build = upstreamCause.getUpstreamBuild();
            }
        }

        public String getUpstreamProject() {
            return this.project;
        }

        public void setUpstreamProject(String p) {
            this.project = p;
        }

        public int getUpstreamBuild() {
            return this.build;
        }

        public void setUpstreamBuild(int buildNr) {
            this.build = buildNr;
        }
    }
}

