/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.graphs;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.graphs.BFAGraph;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import com.sonyericsson.jenkins.plugins.bfa.utils.ObjectCountPair;
import hudson.model.AbstractProject;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class BarChart
extends BFAGraph {
    private boolean byCategories;
    private static final double MAX_BAR_WIDTH = 0.15;

    public BarChart(long timestamp, int defaultW, int defaultH, AbstractProject project, GraphFilterBuilder filter, String graphTitle, boolean byCategories) {
        super(timestamp, defaultW, defaultH, project, filter, graphTitle);
        this.byCategories = byCategories;
    }

    protected JFreeChart createGraph() {
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = ChartFactory.createBarChart((String)this.graphTitle, (String)"", (String)"Number of failures", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        NumberAxis domainAxis = new NumberAxis();
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setRangeAxis((ValueAxis)domainAxis);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setMaximumBarWidth(0.15);
        return chart;
    }

    private CategoryDataset createDataset() {
        String nullFailuteItemsName;
        List<ObjectCountPair<String>> failureItems;
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        KnowledgeBase knowledgeBase = PluginImpl.getInstance().getKnowledgeBase();
        long nullFailureItems = 0L;
        if (this.byCategories) {
            failureItems = knowledgeBase.getNbrOfFailureCategoriesPerName(this.filter, -1);
            nullFailuteItemsName = "Uncategorized";
        } else {
            failureItems = knowledgeBase.getFailureCauseNames(this.filter);
            nullFailureItems = knowledgeBase.getNbrOfNullFailureCauses(this.filter);
            nullFailuteItemsName = "Unknown";
        }
        if (failureItems != null) {
            int othersCount = 0;
            for (int i = 0; i < failureItems.size(); ++i) {
                ObjectCountPair<String> countPair = failureItems.get(i);
                if (countPair.getObject() == null) {
                    nullFailureItems += (long)countPair.getCount();
                    continue;
                }
                if (i < 10) {
                    dataset.setValue((double)countPair.getCount(), (Comparable)((Object)""), (Comparable)((Object)countPair.getObject()));
                    continue;
                }
                othersCount += countPair.getCount();
            }
            if (othersCount > 0) {
                dataset.setValue((double)othersCount, (Comparable)((Object)""), (Comparable)((Object)"Others"));
            }
            if (nullFailureItems > 0L) {
                dataset.addValue((double)nullFailureItems, (Comparable)((Object)""), (Comparable)((Object)nullFailuteItemsName));
            }
        }
        return dataset;
    }
}

