/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.sod;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.sod.ScanOnDemandQueue;
import com.sonyericsson.jenkins.plugins.bfa.sod.ScanOnDemandTask;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.Result;
import hudson.util.RunList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ScanOnDemandBaseAction
implements Action {
    private AbstractProject project;
    public static final String PLUGIN_JS_URL = "/plugin/build-failure-analyzer/js/";
    public static final String NON_SCANNED = "nonscanned";
    private String buildType;

    public ScanOnDemandBaseAction(AbstractProject project) {
        this.project = project;
    }

    public String getJsUrl(String jsName) {
        return PLUGIN_JS_URL + jsName;
    }

    public String getIconFileName() {
        if (this.hasPermission()) {
            return PluginImpl.getDefaultIcon();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.hasPermission()) {
            return Messages.FailureScan_DisplayName();
        }
        return null;
    }

    public String getUrlName() {
        if (this.hasPermission()) {
            return "scan-on-demand";
        }
        return null;
    }

    public boolean hasPermission() {
        return this.project.hasPermission(Item.CONFIGURE) || this.project.hasPermission(Project.BUILD);
    }

    public void checkPermission() {
        if (!this.hasPermission()) {
            throw new AccessDeniedException(Messages.SodAccessDeniedException(Jenkins.getAuthentication().getName(), Item.CONFIGURE.name, Project.BUILD.name));
        }
    }

    public final AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public List<AbstractBuild> getAllBuilds() {
        AbstractProject currentProject = this.project;
        ArrayList<AbstractBuild> sodbuilds = new ArrayList<AbstractBuild>();
        if (currentProject != null) {
            RunList builds = currentProject.getBuilds();
            for (Object build : builds) {
                if (!((AbstractBuild)build).getResult().isWorseThan(Result.SUCCESS)) continue;
                sodbuilds.add((AbstractBuild)build);
            }
        }
        return sodbuilds;
    }

    public List<AbstractBuild> getBuilds(String scanTarget) {
        if (scanTarget != null) {
            this.setBuildType(scanTarget);
        }
        return this.getBuilds();
    }

    public List<AbstractBuild> getBuilds() {
        this.buildType = this.getBuildType();
        if (this.buildType != null) {
            if (this.buildType.length() == 0 | this.buildType.equals(NON_SCANNED)) {
                return this.getNotScannedBuilds();
            }
            return this.getAllBuilds();
        }
        return this.getNotScannedBuilds();
    }

    public List<AbstractBuild> getNotScannedBuilds() {
        ArrayList<AbstractBuild> sodbuilds = new ArrayList<AbstractBuild>();
        if (this.project != null) {
            RunList builds = this.project.getBuilds();
            for (AbstractBuild build : builds) {
                Result result = build.getResult();
                if (result == null || !result.isWorseThan(Result.SUCCESS) || !build.getActions(FailureCauseBuildAction.class).isEmpty() || !build.getActions(FailureCauseMatrixBuildAction.class).isEmpty()) continue;
                sodbuilds.add(build);
            }
        }
        return sodbuilds;
    }

    public void removeRunActions(MatrixBuild build) {
        List runs = build.getRuns();
        for (MatrixRun run : runs) {
            FailureCauseMatrixBuildAction fcmba;
            if (run.getNumber() != build.getNumber()) continue;
            FailureCauseBuildAction fcba = (FailureCauseBuildAction)run.getAction(FailureCauseBuildAction.class);
            if (fcba != null) {
                run.getActions().remove(fcba);
            }
            if ((fcmba = (FailureCauseMatrixBuildAction)run.getAction(FailureCauseMatrixBuildAction.class)) == null) continue;
            run.getActions().remove(fcmba);
        }
    }

    public void doPerformScan(StaplerRequest request, StaplerResponse response) throws ServletException, IOException, InterruptedException {
        this.checkPermission();
        List<AbstractBuild> sodbuilds = this.getBuilds();
        if (sodbuilds.size() > 0) {
            for (AbstractBuild sodbuild : sodbuilds) {
                FailureCauseBuildAction fcba = (FailureCauseBuildAction)sodbuild.getAction(FailureCauseBuildAction.class);
                if (fcba != null) {
                    sodbuild.getActions().remove(fcba);
                }
                FailureCauseMatrixBuildAction fcmba = (FailureCauseMatrixBuildAction)sodbuild.getAction(FailureCauseMatrixBuildAction.class);
                if (sodbuild instanceof MatrixBuild && fcmba != null) {
                    sodbuild.getActions().remove(fcmba);
                    this.removeRunActions((MatrixBuild)sodbuild);
                }
                ScanOnDemandTask task = new ScanOnDemandTask(sodbuild);
                ScanOnDemandQueue.queue(task);
            }
        }
        response.sendRedirect("../");
    }

    public String getBuildType() {
        return this.buildType;
    }

    public void setBuildType(String buildType) {
        this.buildType = buildType;
    }

    public void doSelectBuildType(@QueryParameter(value="build") String scanTarget, StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, InterruptedException {
        if (scanTarget == null) {
            scanTarget = req.getSession() != null && req.getSession().getAttribute("buildType") != null ? (String)req.getSession().getAttribute("buildType") : NON_SCANNED;
        }
        this.setBuildType(scanTarget);
        if (req.getSession() != null) {
            req.getSession(true).setAttribute("buildType", (Object)this.buildType);
        }
        rsp.sendRedirect2(".");
    }
}

