/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.BfaGraphAction;
import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.graphs.BarChart;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphType;
import com.sonyericsson.jenkins.plugins.bfa.graphs.PieChart;
import com.sonyericsson.jenkins.plugins.bfa.graphs.TimeSeriesChart;
import com.sonyericsson.jenkins.plugins.bfa.graphs.TimeSeriesUnkownFailuresChart;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import com.sonyericsson.jenkins.plugins.bfa.utils.BfaUtils;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Failure;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.security.Permission;
import hudson.util.Graph;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class CauseManagement
extends BfaGraphAction {
    private static final Logger logger = Logger.getLogger(CauseManagement.class.getName());
    public static final String URL_NAME = "failure-cause-management";
    public static final String NEW_CAUSE_DYNAMIC_ID = "new";
    public static final String NEW_CAUSE_NAME = "New...";
    public static final String NEW_CAUSE_DESCRIPTION = "Description...";
    public static final String REQUEST_CAUSE_MANAGEMENT_ERROR = "CauseManagementError";
    public static final String SESSION_REMOVED_FAILURE_CAUSE = "removed-failureCause";
    public static final String GRAPH_PAGE_TITLE = "Global statistics";
    private static final String GRAPH_TITLE_CAUSES = "Failure causes for all nodes";
    private static final String GRAPH_TITLE_CATEGORIES = "Failures causes for all nodes grouped by categories";
    private static final String GRAPH_TITLE_UNKNOWN_PERCENTAGE = "Unknown failure causes";

    public String getIconFileName() {
        if (Hudson.getInstance().hasPermission(PluginImpl.UPDATE_PERMISSION) || Hudson.getInstance().hasPermission(PluginImpl.VIEW_PERMISSION)) {
            return PluginImpl.getDefaultIcon();
        }
        return null;
    }

    public String getDisplayName() {
        if (Hudson.getInstance().hasPermission(PluginImpl.UPDATE_PERMISSION)) {
            return Messages.CauseManagement_DisplayName();
        }
        if (Hudson.getInstance().hasPermission(PluginImpl.VIEW_PERMISSION)) {
            return Messages.CauseList_DisplayName();
        }
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getImageUrl(String size, String name) {
        return PluginImpl.getImageUrl(size, name);
    }

    public Iterable<FailureCause> getShallowCauses() throws Exception {
        Collection<FailureCause> returnValue = null;
        try {
            returnValue = PluginImpl.getInstance().getKnowledgeBase().getShallowCauses();
        }
        catch (Exception e) {
            String message = "Could not fetch causes: " + e.getMessage();
            this.setErrorMessage(message);
        }
        return returnValue;
    }

    private void setErrorMessage(String message) {
        Stapler.getCurrentRequest().setAttribute(REQUEST_CAUSE_MANAGEMENT_ERROR, (Object)message);
    }

    public boolean isError(StaplerRequest request) {
        return Util.fixEmpty((String)((String)request.getAttribute(REQUEST_CAUSE_MANAGEMENT_ERROR))) != null;
    }

    public String getErrorMessage(StaplerRequest request) {
        return (String)request.getAttribute(REQUEST_CAUSE_MANAGEMENT_ERROR);
    }

    public FailureCause getDynamic(String id, StaplerRequest request, StaplerResponse response) throws Exception {
        if (NEW_CAUSE_DYNAMIC_ID.equalsIgnoreCase(id)) {
            return new FailureCause(NEW_CAUSE_NAME, NEW_CAUSE_DESCRIPTION);
        }
        return PluginImpl.getInstance().getKnowledgeBase().getCause(id);
    }

    public void doRemoveConfirm(@QueryParameter String id, StaplerRequest request, StaplerResponse response) throws IOException {
        Jenkins.getInstance().checkPermission(PluginImpl.REMOVE_PERMISSION);
        id = Util.fixEmpty((String)id);
        if (id != null) {
            try {
                FailureCause cause = PluginImpl.getInstance().getKnowledgeBase().removeCause(id);
                if (cause != null) {
                    request.getSession(true).setAttribute(SESSION_REMOVED_FAILURE_CAUSE, (Object)cause);
                }
            }
            catch (Exception e) {
                throw (Failure)new Failure(e.getMessage()).initCause((Throwable)e);
            }
        }
        response.sendRedirect2("./");
    }

    @Override
    public ModelObject getOwner() {
        return Hudson.getInstance();
    }

    protected String getOwnerUrl() {
        return "/";
    }

    public ExtensionList<Indication.IndicationDescriptor> getIndicationDescriptors() {
        return Indication.IndicationDescriptor.getAll();
    }

    public Permission getPermission() {
        return PluginImpl.UPDATE_PERMISSION;
    }

    public Permission getRemovePermission() {
        return PluginImpl.REMOVE_PERMISSION;
    }

    public boolean isUnderTest() {
        return "org.jvnet.hudson.test.TestPluginManager".equals(Hudson.getInstance().getPluginManager().getClass().getName());
    }

    public static CauseManagement getInstance() {
        for (Action action : Hudson.getInstance().getActions()) {
            if (!(action instanceof CauseManagement)) continue;
            return (CauseManagement)action;
        }
        throw new IllegalStateException("We seem to not have been initialized!");
    }

    @Override
    public GraphType[] getGraphTypes() {
        return new GraphType[]{GraphType.BAR_CHART_CAUSES, GraphType.PIE_CHART_CAUSES, GraphType.TIME_SERIES_CHART_CAUSES, GraphType.BAR_CHART_CATEGORIES, GraphType.PIE_CHART_CATEGORIES, GraphType.TIME_SERIES_CHART_CATEGORIES, GraphType.TIME_SERIES_UNKNOWN_FAILURES};
    }

    @Override
    public String getGraphsPageTitle() {
        return GRAPH_PAGE_TITLE;
    }

    @Override
    public boolean showMasterSwitch() {
        return true;
    }

    @Override
    public boolean showGraphDelayText() {
        return true;
    }

    @Override
    protected Graph getGraph(GraphType which, Date timePeriod, boolean hideManAborted, boolean forAllMasters, Map<String, String> rawReqParams) {
        GraphFilterBuilder filter = this.getDefaultBuilder(hideManAborted, timePeriod, forAllMasters);
        switch (which) {
            case BAR_CHART_CAUSES: {
                return new BarChart(-1L, 700, 500, null, filter, GRAPH_TITLE_CAUSES, false);
            }
            case BAR_CHART_CATEGORIES: {
                return new BarChart(-1L, 700, 500, null, filter, GRAPH_TITLE_CATEGORIES, true);
            }
            case PIE_CHART_CAUSES: {
                return new PieChart(-1L, 700, 500, null, filter, GRAPH_TITLE_CAUSES, false);
            }
            case PIE_CHART_CATEGORIES: {
                return new PieChart(-1L, 700, 500, null, filter, GRAPH_TITLE_CATEGORIES, true);
            }
            case TIME_SERIES_CHART_CAUSES: {
                return this.getTimeSeriesChart(false, GRAPH_TITLE_CAUSES, filter, rawReqParams);
            }
            case TIME_SERIES_CHART_CATEGORIES: {
                return this.getTimeSeriesChart(true, GRAPH_TITLE_CATEGORIES, filter, rawReqParams);
            }
            case TIME_SERIES_UNKNOWN_FAILURES: {
                return this.getTimeSeriesUnknownFailuresChart(GRAPH_TITLE_UNKNOWN_PERCENTAGE, filter, rawReqParams);
            }
        }
        return null;
    }

    private int addTimeIntervalToFilter(GraphFilterBuilder filter, Map<String, String> rawReqParams) {
        String date = rawReqParams.get("time");
        int interval = 0;
        Calendar cal = Calendar.getInstance();
        if ("today".equals(date)) {
            interval = 11;
            cal.add(6, -1);
        } else if ("month".equals(date)) {
            interval = 5;
            cal.add(2, -1);
        } else {
            interval = 2;
            cal.add(1, -3);
        }
        filter.setSince(cal.getTime());
        return interval;
    }

    private Graph getTimeSeriesUnknownFailuresChart(String title, GraphFilterBuilder filter, Map<String, String> rawReqParams) {
        int interval = this.addTimeIntervalToFilter(filter, rawReqParams);
        return new TimeSeriesUnkownFailuresChart(-1L, 700, 500, null, filter, interval, title);
    }

    private Graph getTimeSeriesChart(boolean byCategories, String title, GraphFilterBuilder filter, Map<String, String> rawReqParams) {
        int interval = this.addTimeIntervalToFilter(filter, rawReqParams);
        return new TimeSeriesChart(-1L, 700, 500, null, filter, interval, byCategories, title);
    }

    private GraphFilterBuilder getDefaultBuilder(boolean hideAborted, Date period, boolean forAllMasters) {
        GraphFilterBuilder filter = new GraphFilterBuilder();
        if (hideAborted) {
            filter.setExcludeResult("ABORTED");
        }
        if (!forAllMasters) {
            filter.setMasterName(BfaUtils.getMasterName());
        }
        filter.setSince(period);
        return filter;
    }

    @Override
    protected String getGraphCacheId(GraphType whichGraph, String reqTimePeriod, boolean hideAborted, boolean forAllMasters) {
        return this.getClass().getSimpleName() + whichGraph.getValue() + reqTimePeriod + String.valueOf(hideAborted) + String.valueOf(forAllMasters);
    }
}

