/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.graphs;

import com.sonyericsson.jenkins.plugins.bfa.BfaGraphAction;
import com.sonyericsson.jenkins.plugins.bfa.graphs.BarChart;
import com.sonyericsson.jenkins.plugins.bfa.graphs.BuildNbrStackedBarChart;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphCache;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphType;
import com.sonyericsson.jenkins.plugins.bfa.graphs.PieChart;
import com.sonyericsson.jenkins.plugins.bfa.utils.BfaUtils;
import hudson.model.AbstractProject;
import hudson.model.ModelObject;
import hudson.util.Graph;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;

public class ProjectGraphAction
extends BfaGraphAction {
    private static final int GRAPH_WIDTH_SMALL = 500;
    private static final int GRAPH_HEIGHT_SMALL = 200;
    private static final int NBR_OF_BUILDS = 25;
    private static final String URL_NAME = "bfa-proj-graphs";
    private static final String PAGE_TITLE = "Statistics for project";
    private static final String GRAPH_TITLE_CAUSES = "Failure causes for this project";
    private static final String GRAPH_TITLE_CAUSES_SMALL = "Failure causes for this project last 30 days";
    private static final String GRAPH_TITLE_CATEGORIES = "Failures grouped by categories for this project";
    private static final String BUILD_NBR_TITLE = "Failure causes per build for this project";
    private AbstractProject project;

    public ProjectGraphAction(AbstractProject project) {
        this.project = project;
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    @Override
    public ModelObject getOwner() {
        return this.project;
    }

    @Override
    public GraphType[] getGraphTypes() {
        return new GraphType[]{GraphType.BAR_CHART_CAUSES, GraphType.PIE_CHART_CAUSES, GraphType.BAR_CHART_CATEGORIES, GraphType.PIE_CHART_CATEGORIES, GraphType.BAR_CHART_BUILD_NBRS};
    }

    @Override
    public String getGraphsPageTitle() {
        return PAGE_TITLE;
    }

    @Override
    protected Graph getGraph(GraphType which, Date timePeriod, boolean hideManAborted, boolean forAllMasters, Map<String, String> rawReqParams) {
        GraphFilterBuilder filter = this.getDefaultBuilder(hideManAborted, timePeriod);
        switch (which) {
            case BAR_CHART_CAUSES_SMALL: {
                return new BarChart(-1L, 500, 200, this.project, filter, GRAPH_TITLE_CAUSES_SMALL, false);
            }
            case BAR_CHART_CAUSES: {
                return new BarChart(-1L, 700, 500, this.project, filter, GRAPH_TITLE_CAUSES, false);
            }
            case BAR_CHART_CATEGORIES: {
                return new BarChart(-1L, 700, 500, this.project, filter, GRAPH_TITLE_CATEGORIES, true);
            }
            case BAR_CHART_BUILD_NBRS: {
                return new BuildNbrStackedBarChart(-1L, 700, 500, this.project, filter, 25, BUILD_NBR_TITLE);
            }
            case PIE_CHART_CAUSES: {
                return new PieChart(-1L, 700, 500, this.project, filter, GRAPH_TITLE_CAUSES, false);
            }
            case PIE_CHART_CATEGORIES: {
                return new PieChart(-1L, 700, 500, this.project, filter, GRAPH_TITLE_CATEGORIES, true);
            }
        }
        return null;
    }

    private GraphFilterBuilder getDefaultBuilder(boolean hideAborted, Date period) {
        GraphFilterBuilder filter = new GraphFilterBuilder();
        filter.setProjectName(this.getProjectName());
        if (hideAborted) {
            filter.setExcludeResult("ABORTED");
        }
        filter.setSince(period);
        filter.setMasterName(BfaUtils.getMasterName());
        return filter;
    }

    @Override
    protected String getGraphCacheId(GraphType whichGraph, String reqTimePeriod, boolean hideAborted, boolean forAllMasters) {
        String id = null;
        id = whichGraph == GraphType.BAR_CHART_BUILD_NBRS ? ProjectGraphAction.getCacheIdForBuildNbrs(this.getProjectName()) : this.getClass().getSimpleName() + '-' + whichGraph.getValue() + '-' + this.getProjectName() + '-' + reqTimePeriod + '-' + String.valueOf(hideAborted);
        return id;
    }

    private static String getCacheIdForBuildNbrs(String projectName) {
        return ProjectGraphAction.class.getSimpleName() + '-' + projectName + '-' + GraphType.BAR_CHART_BUILD_NBRS.getValue();
    }

    private String getProjectName() {
        if (this.project == null) {
            return "";
        }
        return this.project.getFullName();
    }

    public static void invalidateBuildNbrGraphCache(AbstractProject project) {
        GraphCache.getInstance().invalidate(ProjectGraphAction.getCacheIdForBuildNbrs(project.getFullName()));
    }

    public static void invalidateProjectGraphCache(AbstractProject project) {
        Pattern projectPattern = Pattern.compile("^.*-" + project.getFullName() + '-' + ".*$");
        GraphCache.getInstance().invalidateMatching(projectPattern);
    }
}

