/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.AnnotationHelper;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndicationAnnotator
extends ConsoleAnnotator<Object> {
    private Map<String, AnnotationHelper> helperMap = new HashMap<String, AnnotationHelper>();

    public IndicationAnnotator(List<FoundFailureCause> foundFailureCauses) {
        for (FoundFailureCause foundFailureCause : foundFailureCauses) {
            this.addToHelperMap(foundFailureCause);
        }
    }

    private void addToHelperMap(FoundFailureCause cause) {
        for (FoundIndication indication : cause.getIndications()) {
            String matchingString = indication.getFirstMatchingLine();
            if (matchingString == null || matchingString.isEmpty()) continue;
            AnnotationHelper matchingHelper = this.helperMap.get(matchingString);
            if (matchingHelper == null) {
                matchingHelper = new AnnotationHelper();
            }
            matchingHelper.addTitle(cause.getName());
            matchingHelper.addFocus(indication.getMatchingHash() + cause.getId());
            matchingHelper.addAfter("</span>");
            this.helperMap.put(matchingString, matchingHelper);
        }
    }

    public ConsoleAnnotator annotate(Object context, MarkupText text) {
        AnnotationHelper match = this.helperMap.get(text.getText().trim());
        if (match != null) {
            text.wrapBy(match.getBefore(), match.getAfter());
        }
        return this;
    }
}

