/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.GerritMessageProvider;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseDisplayData;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;

@Extension(optional=true)
public class GerritMessageProviderExtension
extends GerritMessageProvider {
    public String getBuildCompletedMessage(AbstractBuild build) {
        if (PluginImpl.getInstance().isGerritTriggerEnabled()) {
            FailureCauseBuildAction action;
            StringBuilder customMessage = new StringBuilder();
            if (build != null && (action = (FailureCauseBuildAction)build.getAction(FailureCauseBuildAction.class)) != null) {
                FailureCauseDisplayData displayData = action.getFailureCauseDisplayData();
                this.addFailureCausesFromData(customMessage, displayData);
                for (FailureCauseDisplayData downstreamCause : displayData.getDownstreamFailureCauses()) {
                    this.addFailureCausesFromData(customMessage, downstreamCause);
                }
                if (customMessage.length() > 0) {
                    return customMessage.toString().replaceAll("'", "\\'");
                }
            }
        }
        return null;
    }

    private void addFailureCausesFromData(StringBuilder message, FailureCauseDisplayData displayData) {
        for (FoundFailureCause failureCause : displayData.getFoundFailureCauses()) {
            if (message.length() > 0) {
                message.append("\n\n");
            }
            message.append(failureCause.getDescription());
            FoundIndication indication = failureCause.getIndications().get(0);
            message.append(" ( ").append(Hudson.getInstance().getRootUrl()).append('/').append(indication.getBuild().getUrl()).append(" )");
        }
    }
}

