/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggeredItemEntity;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import hudson.model.Run;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerContextConverter
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger(TriggerContextConverter.class);

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        List<TriggeredItemEntity> tcOthers;
        TriggerContext tc = (TriggerContext)source;
        if (tc.getEvent() != null) {
            writer.startNode("event");
            writer.addAttribute("class", tc.getEvent().getClass().getName());
            context.convertAnother((Object)tc.getEvent());
            writer.endNode();
        }
        if (tc.getThisBuild() != null) {
            writer.startNode("thisBuild");
            this.marshalItemEntity(tc.getThisBuild(), writer);
            writer.endNode();
        }
        if ((tcOthers = tc.getOthers()) != null && !tcOthers.isEmpty()) {
            writer.startNode("others");
            for (TriggeredItemEntity entity : tcOthers) {
                if (entity == null) continue;
                writer.startNode("triggeredItemEntity");
                this.marshalItemEntity(entity, writer);
                writer.endNode();
            }
            writer.endNode();
        }
    }

    private void marshalItemEntity(TriggeredItemEntity entity, HierarchicalStreamWriter writer) {
        writer.startNode("buildNumber");
        if (entity.getBuildNumber() != null) {
            writer.setValue(entity.getBuildNumber().toString());
        }
        writer.endNode();
        writer.startNode("projectId");
        writer.setValue(entity.getProjectId());
        writer.endNode();
    }

    private TriggeredItemEntity unmarshalItemEntity(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Integer buildNumber = null;
        String projectId = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("buildNumber".equalsIgnoreCase(reader.getNodeName())) {
                String buildNumberStr = reader.getValue();
                if (buildNumberStr != null && buildNumberStr.length() > 0) {
                    try {
                        buildNumber = Integer.parseInt(buildNumberStr);
                    }
                    catch (NumberFormatException e) {
                        throw new ConversionException("Wrong buildNumber format!", (Throwable)e);
                    }
                }
            } else if ("projectId".equalsIgnoreCase(reader.getNodeName())) {
                projectId = reader.getValue();
            }
            reader.moveUp();
        }
        return new TriggeredItemEntity(buildNumber, projectId);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TriggerContext tc = new TriggerContext();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("event".equalsIgnoreCase(reader.getNodeName())) {
                String clazz = reader.getAttribute("class");
                Class<? extends GerritTriggeredEvent> theClass = this.calculateEventClass(clazz);
                GerritTriggeredEvent event = (GerritTriggeredEvent)context.convertAnother((Object)tc, theClass);
                tc.setEvent(event);
            } else if ("thisBuild".equalsIgnoreCase(reader.getNodeName())) {
                TriggeredItemEntity entity = this.unmarshalItemEntity(reader, context);
                tc.setThisBuild(entity);
            } else if ("others".equalsIgnoreCase(reader.getNodeName())) {
                LinkedList<TriggeredItemEntity> list = new LinkedList<TriggeredItemEntity>();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    TriggeredItemEntity entity = this.unmarshalItemEntity(reader, context);
                    list.add(entity);
                    reader.moveUp();
                }
                tc.setOthers(list);
            }
            reader.moveUp();
        }
        return tc;
    }

    private Class<? extends GerritTriggeredEvent> calculateEventClass(String clazz) {
        if (clazz == null) {
            return PatchsetCreated.class;
        }
        Class theClass = null;
        try {
            theClass = Run.XSTREAM2.getMapper().realClass(clazz);
            return theClass;
        }
        catch (CannotResolveClassException | ClassCastException e) {
            logger.error("Failed to unmarshall event type for trigger context!", e);
            return PatchsetCreated.class;
        }
    }

    public boolean canConvert(Class type) {
        return type != null && type.equals(TriggerContext.class);
    }
}

