/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.extensions.GerritTriggeredBuildListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ParameterExpander;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.notification.INotification;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.notification.NotificationBuildCompleted;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.notification.NotificationBuildStarted;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.notification.NotificationCommands;
import com.sonymobile.tools.gerrit.gerritevents.GerritCmdRunner;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import hudson.model.Run;
import hudson.model.TaskListener;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritNotifier {
    private static final Logger logger = LoggerFactory.getLogger(GerritNotifier.class);
    private final GerritCmdRunner cmdRunner;
    private final ParameterExpander parameterExpander;

    public GerritNotifier(IGerritHudsonTriggerConfig config, GerritCmdRunner cmdRunner) {
        this.cmdRunner = cmdRunner;
        this.parameterExpander = new ParameterExpander(config);
    }

    public GerritNotifier(IGerritHudsonTriggerConfig config, GerritCmdRunner cmdRunner, Jenkins jenkins) {
        this.cmdRunner = cmdRunner;
        this.parameterExpander = new ParameterExpander(config, jenkins);
    }

    private void send(INotification notification) {
        if (notification == null) {
            logger.error("NotificationObject is null not sending command!");
            return;
        }
        if (!notification.isValid()) {
            logger.error("Something wrong during parameter extraction. Gerrit will not be notified of BuildStarted!");
            return;
        }
        NotificationCommands notifyCommands = notification.getCommands();
        this.cmdRunner.sendCommand(notifyCommands.getCommand());
        if (notification.isVoteSameTopic()) {
            for (String command : notifyCommands.getCommandsTopicChanges()) {
                this.cmdRunner.sendCommand(command);
            }
        }
    }

    public void buildStarted(Run build, TaskListener taskListener, GerritTriggeredEvent event, BuildsStartedStats stats) {
        try {
            if (event instanceof ChangeBasedEvent) {
                NotificationBuildStarted notification = new NotificationBuildStarted(build, taskListener, event, stats, this.parameterExpander);
                if (notification.isValid()) {
                    this.send(notification);
                    String command = notification.getCommands().getCommand();
                    GerritTriggeredBuildListener.fireOnStarted(event, command);
                } else {
                    logger.error("Notification commands object is not valid. Something went wrong during parameter extraction. Gerrit will not be notified of BuildStarted");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Could not complete BuildStarted notification!", (Throwable)ex);
        }
    }

    public void buildCompleted(BuildMemory.MemoryImprint memoryImprint, TaskListener listener) {
        try {
            if (memoryImprint.getEvent() instanceof ChangeBasedEvent) {
                NotificationBuildCompleted notification = new NotificationBuildCompleted(memoryImprint, listener, this.parameterExpander);
                if (notification.isValid()) {
                    this.send(notification);
                    String command = notification.getCommands().getCommand();
                    GerritTriggeredBuildListener.fireOnCompleted(memoryImprint, command);
                } else {
                    logger.error("Notification commands object is not valid. Something went wrong during parameter extraction. Gerrit will not be notified of BuildCompleted.");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Could not complete BuildCompleted notification!", (Throwable)ex);
        }
    }
}

